/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.java.scanner;

import com.tssap.selena.internal.java.scanner.ClassProcessor;
import com.tssap.selena.internal.java.scanner.JavaScanner;
import com.tssap.selena.internal.java.scanner.JavaScannerContext;
import com.tssap.selena.internal.java.scanner.JavaScannerException;

public class CompilationUnitProcessor {
    private final String myMainTypeName;
    private JavaScannerContext myContext;
    private int myImportsStart = -1;
    private int myImportsEnd = -1;
    private boolean hasImportsStart = false;

    public CompilationUnitProcessor(String mainTypeName) {
        this.myMainTypeName = mainTypeName;
    }

    public void run(JavaScannerContext context) throws JavaScannerException {
        this.myContext = context;
        JavaScanner scanner = context.getScanner();
        scanner.getNextToken();
        while (!scanner.isEOF()) {
            if (scanner.isBareComment()) {
                scanner.getNextToken();
                continue;
            }
            if (scanner.isPackage()) {
                int start = scanner.getCurrentTokenStartPosition();
                scanner.runTo(64);
                String contents = scanner.getSource(start);
                context.addPackageStatement(contents, null, start, scanner.getCurrentTokenEndPosition());
                scanner.getNextToken();
                continue;
            }
            if (scanner.isImport()) {
                if (this.hasImportsStart) {
                    scanner.runTo(64);
                    this.myImportsEnd = scanner.getCurrentTokenEndPosition();
                } else {
                    this.myImportsStart = scanner.getCurrentTokenStartPosition();
                    scanner.runTo(64);
                    this.myImportsEnd = scanner.getCurrentTokenEndPosition();
                    this.hasImportsStart = true;
                }
                scanner.getNextToken();
                continue;
            }
            if (scanner.isJavadoc()) {
                String contents = scanner.getCurrentTokenSourceAsString();
                context.addJavaDoc(contents, contents, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition());
                scanner.getNextToken();
                continue;
            }
            if (scanner.isModifier() || scanner.isClassOrInterface()) {
                if (this.hasImportsStart) {
                    context.addImportSection(scanner.getSource(this.myImportsStart, this.myImportsEnd), null, this.myImportsStart, this.myImportsEnd);
                    this.hasImportsStart = false;
                }
                new ClassProcessor(this.myMainTypeName).run(this.myContext);
                continue;
            }
            System.out.println("? token:" + scanner.getCurrentTokenSourceAsString());
            scanner.getNextToken();
        }
    }
}

