/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.java.scanner;

import com.tssap.selena.internal.java.scanner.JavaScanner;
import com.tssap.selena.internal.java.scanner.JavaScannerContext;
import com.tssap.selena.internal.java.scanner.JavaScannerException;

public final class ClassProcessor {
    private final String myMainTypeName;

    public ClassProcessor(String mainTypeName) {
        this.myMainTypeName = mainTypeName;
    }

    public void run(JavaScannerContext context) throws JavaScannerException {
        JavaScanner scanner = context.getScanner();
        int typeDeclStart = scanner.getCurrentTokenStartPosition();
        if (!this.isMainType(scanner)) {
            scanner.runTo(110);
            this.runToMatchingCloseBrace(scanner);
            context.addSupplementaryType(scanner.getSource(typeDeclStart), null, typeDeclStart, scanner.getCurrentTokenEndPosition());
            scanner.getNextToken();
            return;
        }
        scanner.runTo(110);
        context.addType(scanner.getSource(typeDeclStart), null, typeDeclStart, scanner.getCurrentTokenEndPosition());
        ClassProcessor.getNextRealToken(scanner);
        while (!scanner.isCloseBrace()) {
            if (scanner.isJavadoc()) {
                context.addJavaDoc(scanner.getCurrentTokenSourceAsString(), null, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition());
                ClassProcessor.getNextRealToken(scanner);
                continue;
            }
            if (scanner.isDesignComment()) {
                context.addDesignComment(scanner.getCurrentTokenSourceAsString(), null, scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition());
                ClassProcessor.getNextRealToken(scanner);
                continue;
            }
            if (scanner.isFieldOrMethodStart() || scanner.isClassOrInterface()) {
                this.handleMember(context);
                continue;
            }
            ClassProcessor.getNextRealToken(scanner);
        }
        context.finishType();
        scanner.getNextToken();
    }

    private static int getNextRealToken(JavaScanner scanner) throws JavaScannerException {
        do {
            scanner.getNextToken();
            scanner.checkNotEof();
        } while (scanner.isBareComment());
        return scanner.getCurrentToken();
    }

    private static void checkAssertion(boolean condition) {
        if (condition) {
            return;
        }
        throw new IllegalStateException();
    }

    private void runToMatchingCloseBrace(JavaScanner scanner) throws JavaScannerException {
        ClassProcessor.checkAssertion(scanner.isOpenBrace());
        int braceNestingLevel = 1;
        do {
            ClassProcessor.getNextRealToken(scanner);
            if (scanner.isOpenBrace()) {
                ++braceNestingLevel;
                continue;
            }
            if (!scanner.isCloseBrace()) continue;
            --braceNestingLevel;
        } while (braceNestingLevel != 0);
    }

    private boolean isMainType(JavaScanner scanner) throws JavaScannerException {
        while (!scanner.isClassOrInterface()) {
            ClassProcessor.getNextRealToken(scanner);
        }
        ClassProcessor.getNextRealToken(scanner);
        ClassProcessor.checkAssertion(scanner.isIdentifier());
        return this.myMainTypeName.equals(scanner.getCurrentTokenSourceAsString());
    }

    private void handleMember(JavaScannerContext context) throws JavaScannerException {
        JavaScanner scanner = context.getScanner();
        int start = scanner.getCurrentTokenStartPosition();
        boolean isInnerType = scanner.isClassOrInterface();
        boolean hasAssignment = false;
        boolean hasLeftParen = false;
        boolean hasRightParen = false;
        do {
            ClassProcessor.getNextRealToken(scanner);
            if (scanner.isClassOrInterface()) {
                isInnerType = true;
                continue;
            }
            if (scanner.isAssignOperator()) {
                hasAssignment = true;
                continue;
            }
            if (scanner.isLeftParen()) {
                hasLeftParen = true;
                continue;
            }
            if (!scanner.isRightParen()) continue;
            hasRightParen = true;
        } while (!scanner.isSemicolon() && !scanner.isOpenBrace() && !hasAssignment);
        ClassProcessor.checkAssertion(hasLeftParen == hasRightParen);
        if (hasAssignment) {
            int braceNestingLevel = 0;
            do {
                ClassProcessor.getNextRealToken(scanner);
                if (scanner.isOpenBrace()) {
                    ++braceNestingLevel;
                    continue;
                }
                if (!scanner.isCloseBrace()) continue;
                --braceNestingLevel;
            } while (braceNestingLevel > 0 || !scanner.isSemicolon());
            context.addField(scanner.getSource(start), null, start, scanner.getCurrentTokenEndPosition());
            ClassProcessor.getNextRealToken(scanner);
            return;
        }
        if (scanner.isSemicolon()) {
            ClassProcessor.checkAssertion(!isInnerType);
            if (hasLeftParen) {
                context.addMethod(scanner.getSource(start), null, start, scanner.getCurrentTokenEndPosition());
            } else {
                context.addField(scanner.getSource(start), null, start, scanner.getCurrentTokenEndPosition());
            }
            ClassProcessor.getNextRealToken(scanner);
            return;
        }
        if (scanner.isOpenBrace()) {
            this.runToMatchingCloseBrace(scanner);
            int lastBraceFoundPosition = scanner.getCurrentTokenEndPosition();
            ClassProcessor.getNextRealToken(scanner);
            if (scanner.isSemicolon()) {
                if (isInnerType) {
                    context.addInnerType(scanner.getSource(start), null, start, scanner.getCurrentTokenEndPosition());
                } else {
                    context.addField(scanner.getSource(start), null, start, scanner.getCurrentTokenEndPosition());
                }
                ClassProcessor.getNextRealToken(scanner);
                return;
            }
            if (isInnerType) {
                context.addInnerType(scanner.getSource(start, lastBraceFoundPosition), null, start, lastBraceFoundPosition);
            } else {
                context.addMethod(scanner.getSource(start, lastBraceFoundPosition), null, start, lastBraceFoundPosition);
            }
        }
    }
}

