/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.java.partition;

import com.tssap.selena.internal.java.partition.JavaBlockWithDoc;
import com.tssap.selena.internal.java.partition.JavaSourceBlock;
import com.tssap.selena.internal.java.scanner.JavaScanner;
import com.tssap.selena.internal.java.scanner.JavaScannerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class JavaScannerBlockContext
implements JavaScannerContext {
    public static final int IMPORT = 0;
    public static final int TYPE = 1;
    public static final int FIELD = 2;
    public static final int METHOD = 3;
    public static final int INNER_TYPE = 4;
    public static final int JAVADOC = 5;
    public static final int DESIGN_COMMENT = 6;
    public static final int SUPPLEMENTARY_TYPE = 7;
    private final JavaScanner myScanner;
    private JavaSourceBlock myLastJavadoc = null;
    private List myBlocks;

    public JavaScannerBlockContext(JavaScanner scanner) {
        this.myScanner = scanner;
        this.myBlocks = new ArrayList();
    }

    public JavaScanner getScanner() {
        return this.myScanner;
    }

    public List getBlocks() {
        return Collections.unmodifiableList(this.myBlocks);
    }

    public void addPackageStatement(String contents, String declaration, int start, int end) {
        this.myLastJavadoc = null;
    }

    public void addImportSection(String contents, String declaration, int start, int end) {
        this.internalAddBlock(new JavaSourceBlock(0, contents, null, start, end));
        this.myLastJavadoc = null;
    }

    public void addType(String contents, String declaration, int start, int end) {
        this.internalAddBlock(new JavaBlockWithDoc(this.myLastJavadoc, 1, contents, declaration, start, end));
        this.myLastJavadoc = null;
    }

    public void addJavaDoc(String contents, String declaration, int start, int end) {
        if (this.myLastJavadoc != null) {
            this.internalAddBlock(this.myLastJavadoc);
        }
        this.myLastJavadoc = new JavaSourceBlock(5, contents, null, start, end);
    }

    public void addDesignComment(String contents, String declaration, int start, int end) {
        this.internalAddBlock(new JavaBlockWithDoc(this.myLastJavadoc, 6, contents, declaration, start, end));
        this.myLastJavadoc = null;
    }

    public void addField(String contents, String declaration, int start, int end) {
        this.internalAddBlock(new JavaBlockWithDoc(this.myLastJavadoc, 2, contents, declaration, start, end));
        this.myLastJavadoc = null;
    }

    public void addMethod(String contents, String declaration, int start, int end) {
        this.internalAddBlock(new JavaBlockWithDoc(this.myLastJavadoc, 3, contents, declaration, start, end));
        this.myLastJavadoc = null;
    }

    public void addInnerType(String contents, String declaration, int start, int end) {
        this.internalAddBlock(new JavaBlockWithDoc(this.myLastJavadoc, 4, contents, declaration, start, end));
        this.myLastJavadoc = null;
    }

    public void addSupplementaryType(String contents, String declaration, int start, int end) {
        this.internalAddBlock(new JavaBlockWithDoc(this.myLastJavadoc, 7, contents, declaration, start, end));
        this.myLastJavadoc = null;
    }

    public void finishType() {
        if (this.myLastJavadoc != null) {
            this.internalAddBlock(this.myLastJavadoc);
            this.myLastJavadoc = null;
        }
    }

    private void internalAddBlock(JavaSourceBlock block) {
        this.myBlocks.add(block);
    }
}

