/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.java.diff;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.java.diff.BlockDiffElement;
import com.tssap.selena.internal.java.diff.JavaDiffElement;
import com.tssap.selena.internal.java.diff.JavaDiffRequestor;
import com.tssap.selena.internal.java.diff.JavaSourceContentsState;
import com.tssap.selena.internal.java.partition.JavaScannerBlockContext;
import com.tssap.selena.internal.java.partition.JavaSourceBlock;
import com.tssap.selena.internal.java.scanner.CompilationUnitProcessor;
import com.tssap.selena.internal.java.scanner.JavaScanner;
import com.tssap.selena.internal.java.scanner.JavaScannerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;

public abstract class JavaDifferencer {
    private final JavaScannerBlockContext myContext;

    protected JavaDifferencer(String source) {
        this.myContext = new JavaScannerBlockContext(new JavaScanner(source));
    }

    public static void process(JavaDiffRequestor requestor) throws CoreException {
        JavaSourceContentsState sourceContents = requestor.getSourceContentsState();
        String mainTypeName = JavaDifferencer.getMainTypeName(sourceContents.getCompilationUnit());
        CompilationUnitDifferencer diff1 = new CompilationUnitDifferencer(sourceContents.getLastState(), mainTypeName);
        CompilationUnitDifferencer diff2 = new CompilationUnitDifferencer(sourceContents.getPreviousState(), mainTypeName);
        JavaDifferencer.process(diff1, diff2, requestor);
    }

    private static void process(JavaDifferencer diff1, JavaDifferencer diff2, JavaDiffRequestor requestor) throws CoreException {
        try {
            diff1.parse();
            diff2.parse();
            List changes = diff2.compareTo(diff1);
            Iterator it = changes.iterator();
            while (it.hasNext()) {
                JavaDiffElement next = (JavaDiffElement)it.next();
                if (next.isAdded()) {
                    requestor.added(next);
                    continue;
                }
                if (next.isChanged()) {
                    requestor.changed(next);
                    continue;
                }
                if (next.isDeleted()) {
                    requestor.deleted(next);
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        catch (JavaScannerException ex) {
            Exception e = ex;
            if (ex.getNested() != null) {
                e = ex.getNested();
            }
            throw new CoreException((IStatus)new Status(4, JavaProviderPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, e.getMessage(), (Throwable)e));
        }
    }

    protected JavaScannerBlockContext getContext() {
        return this.myContext;
    }

    private List compareTo(JavaDifferencer diff) {
        JavaSourceBlock[] mine = this.getBlocks();
        JavaSourceBlock[] another = diff.getBlocks();
        JavaDifferencer.removeCommon(mine, another);
        return JavaDifferencer.constructDifferences(mine, another);
    }

    private static void removeCommon(JavaSourceBlock[] mine, JavaSourceBlock[] another) {
        int i = 0;
        while (i < mine.length) {
            int idx = JavaDifferencer.findMatch(another, mine[i]);
            if (idx != -1) {
                mine[i] = null;
                another[idx] = null;
            }
            ++i;
        }
    }

    private static List constructDifferences(JavaSourceBlock[] left, JavaSourceBlock[] right) {
        ArrayList<JavaDiffElement> result = new ArrayList<JavaDiffElement>(left.length);
        int commonLength = Math.min(left.length, right.length);
        int i = 0;
        while (i < commonLength) {
            if (left[i] == right[i]) {
                JavaDifferencer.checkAssertion(right[i] == null);
            } else if (left[i] != null) {
                if (right[i] == null) {
                    result.add(BlockDiffElement.createDeleted(left[i]));
                } else if (left[i].isEqualBlockType(right[i])) {
                    result.add(BlockDiffElement.createChanged(left[i], right[i]));
                } else {
                    result.add(BlockDiffElement.createDeleted(left[i]));
                    result.add(BlockDiffElement.createAdded(right[i]));
                }
            } else {
                result.add(BlockDiffElement.createAdded(right[i]));
            }
            ++i;
        }
        if (commonLength == left.length) {
            int i2 = commonLength;
            while (i2 < right.length) {
                if (right[i2] != null) {
                    result.add(BlockDiffElement.createAdded(right[i2]));
                }
                ++i2;
            }
        } else {
            int i3 = commonLength;
            while (i3 < left.length) {
                if (left[i3] != null) {
                    result.add(BlockDiffElement.createDeleted(left[i3]));
                }
                ++i3;
            }
        }
        return result;
    }

    private static int findMatch(JavaSourceBlock[] where, JavaSourceBlock what) {
        int i = 0;
        while (i < where.length) {
            if (where[i] != null && what.isEqualBlockType(where[i]) && what.getSourceRange().getLength() == where[i].getSourceRange().getLength() && what.getSource().equals(where[i].getSource())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private JavaSourceBlock[] getBlocks() {
        List blocks = this.myContext.getBlocks();
        JavaSourceBlock[] rv = new JavaSourceBlock[blocks.size()];
        blocks.toArray(rv);
        return rv;
    }

    protected abstract void parse() throws JavaScannerException;

    private static String getMainTypeName(ICompilationUnit cu) throws JavaModelException {
        String cuName = cu.getUnderlyingResource().getName();
        JavaDifferencer.checkAssertion(cuName != null && cuName.endsWith(".java"));
        return cuName.substring(0, cuName.length() - ".java".length());
    }

    private static void checkAssertion(boolean condition) {
        if (condition) {
            return;
        }
        throw new IllegalStateException();
    }

    private static class CompilationUnitDifferencer
    extends JavaDifferencer {
        private final String myMainTypeName;

        CompilationUnitDifferencer(String cuSource, String mainTypeName) {
            super(cuSource);
            JavaDifferencer.checkAssertion(mainTypeName != null);
            this.myMainTypeName = mainTypeName;
        }

        protected void parse() throws JavaScannerException {
            new CompilationUnitProcessor(this.myMainTypeName).run(this.getContext());
        }
    }
}

