/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.java.diff;

import com.tssap.selena.internal.java.diff.JavaDiffElement;
import com.tssap.selena.internal.java.diff.TypeInspector;
import com.tssap.selena.internal.java.partition.JavaSourceBlock;
import org.eclipse.jdt.core.ISourceRange;

class BlockDiffElement
implements JavaDiffElement {
    private final JavaSourceBlock myBlock;

    private BlockDiffElement(JavaSourceBlock block) {
        if (block == null) {
            throw new NullPointerException();
        }
        this.myBlock = block;
    }

    public String getSource() {
        return this.myBlock.getSource();
    }

    public ISourceRange getSourceRange() {
        return this.myBlock.getSourceRange();
    }

    public String getDeclaration() {
        return this.myBlock.getDeclaration();
    }

    public String getOriginalSource() {
        return null;
    }

    public boolean isAdded() {
        return false;
    }

    public boolean isChanged() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public void admit(TypeInspector typeInspector) {
        switch (this.myBlock.getType()) {
            case 0: {
                typeInspector.inspectImport(this);
                break;
            }
            case 1: {
                typeInspector.inspectType(this);
                break;
            }
            case 2: {
                typeInspector.inspectField(this);
                break;
            }
            case 3: {
                typeInspector.inspectMethod(this);
                break;
            }
            case 4: {
                typeInspector.inspectInnerType(this);
                break;
            }
            case 5: {
                typeInspector.inspectJavaDoc(this);
                break;
            }
            case 6: {
                typeInspector.inspectDesignComment(this);
                break;
            }
            case 7: {
                typeInspector.inspectSupplementaryType(this);
            }
        }
    }

    static JavaDiffElement createAdded(JavaSourceBlock block) {
        return new BlockDiffElement(block){

            public boolean isAdded() {
                return true;
            }
        };
    }

    static JavaDiffElement createChanged(final JavaSourceBlock from, JavaSourceBlock to) {
        return new BlockDiffElement(to){

            public boolean isChanged() {
                return true;
            }

            public String getOriginalSource() {
                return from.getSource();
            }
        };
    }

    static JavaDiffElement createDeleted(JavaSourceBlock block) {
        return new BlockDiffElement(block){

            public boolean isDeleted() {
                return true;
            }
        };
    }
}

