/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.ui.preferencepages;

import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.Messages;
import com.tssap.selena.internal.core.providers.java.NullMonitor;
import com.tssap.selena.internal.core.providers.java.WorkingCopyUtil;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import com.tssap.selena.ui.prefpages.FieldEditorPreferenceTabPage;
import com.tssap.selena.ui.prefpages.OrgerStringFieldEditor;
import java.util.Enumeration;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JavaPreferencePage
extends FieldEditorPreferenceTabPage
implements IWorkbenchPreferencePage {
    private boolean myPreviousSRTEnabled;
    private static final String ALL_NAME = Messages.getString("all");
    private static final String NONE_NAME = Messages.getString("none");
    private static final String AUTOMATIC_NAME = Messages.getString("automatic");
    private static final String[][] NAMES_AND_VALUES = new String[][]{{ALL_NAME, "all"}, {NONE_NAME, "none"}, {AUTOMATIC_NAME, "automatic"}};
    private static final String LNK_FIELD_PREFIX = Messages.getString("link_prefix");
    private static final String SRT_ENABLED = Messages.getString("srt_enabled");
    private static final String SAVE_RESOURCES = Messages.getString("save_resources_automatically");
    private static final String OPTIMIZE_IMPORT = Messages.getString("optimize_import");
    private static final String SHOW_AS_ATTRIBUTE = Messages.getString("show_as_attribute");
    private static final String DELETE_ATTRIBUTE = Messages.getString("delete_attribute");
    private static final String UPDATE_EXTENDS_LIST = Messages.getString("update_extends");
    private static final String REFACTOR_NAMES = Messages.getString("refactor_names");
    private static final String HIDE_PROPERTIES_PARTICIPANTS_LABEL = Messages.getString("hide_properties_participants");
    private static final String RECOGNIZE_PROPERTIES_LABEL = Messages.getString("recognize_properties");
    private static final String DEFAULT_MEMBER_ORDER_LABEL = Messages.getString("member_order_label");
    private static final String DEFAULT_VISIBILITY_ORDER_LABEL = Messages.getString("visibility_order_label");

    public JavaPreferencePage() {
        super(0);
        IPreferenceStore store = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
        this.setPreferenceStore(store);
    }

    private Composite createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setText(name);
        Composite result = new Composite((Composite)group, 0);
        result.setLayoutData((Object)new GridData(1808));
        return result;
    }

    private void setCompositeLayout(Composite comp, int columns) {
        GridLayout layout = new GridLayout(columns, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite source = this.createGroup(parent, Messages.getString("source_code"));
        this.addField((FieldEditor)new BooleanFieldEditor("srt_enabled", SRT_ENABLED, 0, source));
        this.addField((FieldEditor)new BooleanFieldEditor("save_resources_automatically", SAVE_RESOURCES, 0, source));
        this.addField((FieldEditor)new BooleanFieldEditor("optimize_import_enabled", OPTIMIZE_IMPORT, 0, source));
        this.addField((FieldEditor)new BooleanFieldEditor("refactor_default_names", REFACTOR_NAMES, 0, source));
        this.setCompositeLayout(source, 1);
        Composite associations = this.createGroup(parent, Messages.getString("associations"));
        this.addField((FieldEditor)new StringFieldEditor("lnk_field_prefix", LNK_FIELD_PREFIX, 10, associations));
        this.addField((FieldEditor)new RadioGroupFieldEditor("show_as_attribute", SHOW_AS_ATTRIBUTE, 3, NAMES_AND_VALUES, associations));
        this.setCompositeLayout(associations, 2);
        Composite linkdel = this.createGroup(parent, Messages.getString("link_deletion"));
        this.addField((FieldEditor)new BooleanFieldEditor("delete_attribute", DELETE_ATTRIBUTE, 0, linkdel));
        this.addField((FieldEditor)new BooleanFieldEditor("update_extends", UPDATE_EXTENDS_LIST, 0, linkdel));
        this.setCompositeLayout(linkdel, 1);
        Composite properties = this.createGroup(parent, Messages.getString("properties"));
        this.addField((FieldEditor)new BooleanFieldEditor("recognize_properties", RECOGNIZE_PROPERTIES_LABEL, 0, properties));
        this.addField((FieldEditor)new BooleanFieldEditor("hide_properties_participants", HIDE_PROPERTIES_PARTICIPANTS_LABEL, 0, properties));
        this.setCompositeLayout(properties, 1);
        Composite nameTemplate = this.createGroup(parent, Messages.getString("name_template"));
        this.addField((FieldEditor)new StringFieldEditor("class_name_template", Messages.getString("class_name_template"), 10, nameTemplate));
        this.addField((FieldEditor)new StringFieldEditor("inner_class_name_template", Messages.getString("inner_class_name_template"), 10, nameTemplate));
        this.addField((FieldEditor)new StringFieldEditor("interface_name_template", Messages.getString("interface_name_template"), 10, nameTemplate));
        this.addField((FieldEditor)new StringFieldEditor("inner_interface_name_template", Messages.getString("inner_interface_name_template"), 10, nameTemplate));
        this.addField((FieldEditor)new StringFieldEditor("field_name_template", Messages.getString("field_name_template"), 10, nameTemplate));
        this.addField((FieldEditor)new StringFieldEditor("method_name_template", Messages.getString("method_name_template"), 10, nameTemplate));
        this.setCompositeLayout(nameTemplate, 4);
        Composite member_order = this.createGroup(parent, Messages.getString("member_order"));
        this.addField((FieldEditor)new OrgerStringFieldEditor("default_member_order", DEFAULT_MEMBER_ORDER_LABEL, member_order));
        this.addField((FieldEditor)new OrgerStringFieldEditor("default_visibility_order", DEFAULT_VISIBILITY_ORDER_LABEL, member_order));
        this.setCompositeLayout(member_order, 2);
    }

    public void init(IWorkbench workbench) {
        boolean bl = JavaProviderPlugin.isSRTEnabled();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        boolean srtEnabled = JavaProviderPlugin.isSRTEnabled();
        if (this.myPreviousSRTEnabled != srtEnabled) {
            IEditorPart[] editorParts = JavaPlugin.getDirtyEditors();
            int i = 0;
            while (i < editorParts.length) {
                if (editorParts[i] instanceof CompilationUnitEditor) {
                    editorParts[i].doSave(NullMonitor.getSharedInstance());
                    ICompilationUnit compilationUnit = EditorUtil.getCompilationUnit(editorParts[i]);
                    WorkingCopyUtil.dropWorkingCopies((IJavaElement)compilationUnit);
                }
                ++i;
            }
        }
        this.update();
        return result;
    }

    protected void update() {
        Enumeration models = ModelAccess.models();
        while (models.hasMoreElements()) {
            Model theModel = (Model)models.nextElement();
            UniqueName modelUIN = theModel.getUniqueName();
            ViewManager viewManager = ViewAccess.getViewManager((UniqueName)modelUIN);
            viewManager.updateAllViews();
        }
    }
}

