/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.test;

import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.util.function.UnaryOperation;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class Utils {
    public static Vector collectJDTModelInformation(Vector target, IJavaProject javaProject, UnaryOperation collector) {
        try {
            if (target == null) {
                target = new Vector();
            }
            IPackageFragment[] packageFragments = javaProject.getPackageFragments();
            int i = 0;
            while (i < packageFragments.length) {
                Utils.addToResult(target, packageFragments[i], collector);
                ICompilationUnit[] compilationUnit = packageFragments[i].getCompilationUnits();
                int j = 0;
                while (j < compilationUnit.length) {
                    IType[] types = compilationUnit[j].getAllTypes();
                    int t = 0;
                    while (t < types.length) {
                        Utils.addToResult(target, types[t], collector);
                        IMethod[] methods = types[t].getMethods();
                        int p = 0;
                        while (p < methods.length) {
                            Utils.addToResult(target, methods[p], collector);
                            ++p;
                        }
                        IField[] fields = types[t].getFields();
                        int p2 = 0;
                        while (p2 < fields.length) {
                            Utils.addToResult(target, fields[p2], collector);
                            ++p2;
                        }
                        ++t;
                    }
                    ++j;
                }
                ++i;
            }
            return target;
        }
        catch (JavaModelException e) {
            return target;
        }
    }

    public static boolean checkElements(Model model, UniqueName[] elementsUniqueNames, boolean mustBeFound) {
        int i = 0;
        while (i < elementsUniqueNames.length) {
            UniqueName uniqueName = elementsUniqueNames[i];
            Entity element = model.findEntity(uniqueName);
            if (mustBeFound ? element == null : element != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void addToResult(Vector target, Object element, UnaryOperation collector) {
        Object result = collector.execute(element);
        if (result != null) {
            target.addElement(result);
        }
    }

    public static Vector collectModelInformation(Vector target, Container container, UnaryOperation collector) {
        if (target == null) {
            target = new Vector();
        }
        EntityEnumeration elements = container.childEntities();
        while (elements.hasMoreElements()) {
            Entity element = elements.next();
            Object result = collector.execute((Object)element);
            if (result != null) {
                target.addElement(result);
            }
            target = Utils.collectModelInformation(target, (Container)element, collector);
        }
        return target;
    }

    public static boolean compareVectors(Vector source, Vector target) {
        if (source.size() != target.size()) {
            return false;
        }
        source = (Vector)source.clone();
        target = (Vector)target.clone();
        int i = 0;
        while (i < target.size()) {
            source.removeElement(target.elementAt(i));
            ++i;
        }
        return source.size() == 0;
    }

    public static boolean containVector(Vector source, Vector target) {
        source = (Vector)source.clone();
        target = (Vector)target.clone();
        int i = 0;
        while (i < source.size()) {
            target.removeElement(source.elementAt(i));
            ++i;
        }
        return target.size() == 0;
    }
}

