/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.test;

import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.test.AbstractTest;
import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class PerfomanceTest
extends AbstractTest {
    private int counter = 0;

    public PerfomanceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void offtestJDTPerfomance() throws Exception {
        this.appendRTJar();
        try {
            IPackageFragment[] myPackageFragments = this.myJavaProject.getPackageFragments();
            this.counter = 0;
            long ms = System.currentTimeMillis();
            int i = 0;
            while (i < myPackageFragments.length) {
                IPackageFragment packageFragment = myPackageFragments[i];
                if (!packageFragment.getElementName().equals("")) {
                    ++this.counter;
                    this.timePerformanceIteratePackages(packageFragment);
                }
                ++i;
            }
            ms = System.currentTimeMillis() - ms;
            System.out.println("jdt first time " + ms + " counter " + this.counter);
            ms = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < myPackageFragments.length) {
                IPackageFragment packageFragment = myPackageFragments[i2];
                if (!packageFragment.getElementName().equals("")) {
                    this.timePerformanceIteratePackages(packageFragment);
                }
                ++i2;
            }
            ms = System.currentTimeMillis() - ms;
            System.out.println("jdt second time " + ms);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.removeRTJar();
            throw throwable;
        }
        this.removeRTJar();
    }

    public void testModelPerfomance() throws Exception {
        this.appendRTJar();
        try {
            long ms = System.currentTimeMillis();
            this.counter = 0;
            this.timePerformanceIterateContainer((Container)this.myModel);
            ms = System.currentTimeMillis() - ms;
            System.out.println("model first time " + ms + " counter " + this.counter);
            this.counter = 0;
            ms = System.currentTimeMillis();
            this.timePerformanceIterateContainer((Container)this.myModel);
            ms = System.currentTimeMillis() - ms;
            System.out.println("model second time " + ms);
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.removeRTJar();
            throw throwable;
        }
        this.removeRTJar();
    }

    private void timePerformanceIterateContainer(Container container) throws Exception {
        EntityEnumeration entities = container.childEntities();
        while (entities.hasMoreElements()) {
            Entity entity = entities.next();
            UniqueName uniqueName = entity.getUniqueName();
            if (!NameUtil.isJavaUniqueName(uniqueName)) continue;
            entity.getProperty("$name");
            ++this.counter;
            if (this.counter % 1000 == 0) {
                System.out.println("\tcounter " + this.counter);
            }
            this.timePerformanceIterateContainer((Container)entity);
        }
    }

    private void timePerformanceIteratePackages(IPackageFragment packageFragment) throws Exception {
        ICompilationUnit[] compilationUnits = packageFragment.getCompilationUnits();
        int i = 0;
        while (i < compilationUnits.length) {
            IType[] types = compilationUnits[i].getAllTypes();
            int j = 0;
            while (j < types.length) {
                ++this.counter;
                types[j].getElementName();
                this.timePerformanceIteratePackages(types[j]);
                ++j;
            }
            ++i;
        }
        IClassFile[] classFiles = packageFragment.getClassFiles();
        int i2 = 0;
        while (i2 < classFiles.length) {
            this.timePerformanceIteratePackages(classFiles[i2].getType());
            ++i2;
        }
    }

    private void timePerformanceIteratePackages(IType type) throws Exception {
        IType[] types = type.getTypes();
        int i = 0;
        while (i < types.length) {
            ++this.counter;
            types[i].getElementName();
            ++i;
        }
        IField[] field = type.getFields();
        int i2 = 0;
        while (i2 < field.length) {
            ++this.counter;
            field[i2].getElementName();
            ++i2;
        }
        IMethod[] method = type.getMethods();
        int i3 = 0;
        while (i3 < method.length) {
            ++this.counter;
            method[i3].getElementName();
            ++i3;
        }
    }
}

