/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.test;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.test.AbstractTest;
import junit.framework.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class DeltaTest
extends AbstractTest
implements IElementChangedListener {
    private IJavaElement myDeltaJavaElement;
    private int myKindOfDeltaJavaElement;
    private IPackageFragment myDefaultPackage;
    public static final String NEW_FILE_NAME = "NewClass1.java";
    public static final String NEW_CLASS1_CONTENTS = "public class NewClass1 {\n}\n";
    public static final String NEW_ATTRIBUTE11_CONTENTS = "private int attribute11;\n";
    public static final String NEW_METHOD11_CONTENTS = "private int method11(int i) {\n};\n";
    public static final String NEW_CLASS2_CONTENTS = "class NewClass2 {\n}\n";
    public static final String NEW_ATTRIBUTE21_CONTENTS = "private int attribute21;\n";
    public static final String NEW_METHOD21_CONTENTS = "private int method21(int i) {\n};\n";

    public DeltaTest(String name) {
        super(name);
    }

    public void testAddRemove() throws Throwable {
        ICompilationUnit compilationUnit = this.myDefaultPackage.createCompilationUnit(NEW_FILE_NAME, "", false, null);
        Assert.assertNotNull((String)"Compilation unit not created ", (Object)compilationUnit);
        IType type1 = compilationUnit.createType(NEW_CLASS1_CONTENTS, null, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"Type not created ", (Object)type1);
        boolean result = "NewClass1".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
        Assert.assertTrue((String)"It haven't get notification about 'NewClass1' added", (boolean)result);
        this.clearDelta();
        IType type2 = compilationUnit.createType(NEW_CLASS2_CONTENTS, null, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"Type not created ", (Object)type2);
        result = "NewClass2".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
        Assert.assertTrue((String)"It haven't get notification about 'NewClass2' added", (boolean)result);
        this.clearDelta();
        IField field11 = type1.createField(NEW_ATTRIBUTE11_CONTENTS, null, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"IField not created ", (Object)field11);
        result = "attribute11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
        Assert.assertTrue((String)"It haven't get notification about 'attribute11' added", (boolean)result);
        this.clearDelta();
        IField field21 = type2.createField(NEW_ATTRIBUTE21_CONTENTS, null, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"IField not created ", (Object)field21);
        result = "attribute21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
        Assert.assertTrue((String)"It haven't get notification about 'attribute21' added", (boolean)result);
        this.clearDelta();
        IMethod method11 = type1.createMethod(NEW_METHOD11_CONTENTS, null, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"IMethod not created ", (Object)method11);
        result = "method11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
        Assert.assertTrue((String)"It haven't get notification about 'method11' added", (boolean)result);
        this.clearDelta();
        IMethod method21 = type2.createMethod(NEW_METHOD21_CONTENTS, null, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"IMethod not created ", (Object)method21);
        result = "method21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
        Assert.assertTrue((String)"It haven't get notification about 'method21' added", (boolean)result);
        this.clearDelta();
        method11.delete(true, (IProgressMonitor)new NullProgressMonitor());
        result = "method11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
        Assert.assertTrue((String)"It haven't get notification about 'method11' deleted", (boolean)result);
        this.clearDelta();
        method21.delete(true, (IProgressMonitor)new NullProgressMonitor());
        result = "method21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
        Assert.assertTrue((String)"It haven't get notification about 'method21' deleted", (boolean)result);
        this.clearDelta();
        field11.delete(true, (IProgressMonitor)new NullProgressMonitor());
        result = "attribute11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
        Assert.assertTrue((String)"It haven't get notification about 'attribute11' deleted", (boolean)result);
        this.clearDelta();
        field21.delete(true, (IProgressMonitor)new NullProgressMonitor());
        result = "attribute21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
        Assert.assertTrue((String)"It haven't get notification about 'attribute21' deleted", (boolean)result);
        this.clearDelta();
        type1.delete(true, (IProgressMonitor)new NullProgressMonitor());
        result = "NewClass1".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
        Assert.assertTrue((String)"It haven't get notification about 'NewClass1' deleted", (boolean)result);
        this.clearDelta();
        type2.delete(true, (IProgressMonitor)new NullProgressMonitor());
        result = "NewClass2".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
        Assert.assertTrue((String)"It haven't get notification about 'NewClass2' deleted", (boolean)result);
        this.clearDelta();
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        this.processDelta(delta);
    }

    public void processDelta(IJavaElementDelta delta) {
        IJavaElement javaElement = delta.getElement();
        int kindOfDelta = delta.getKind();
        IJavaElementDelta[] childrenDeltas = delta.getAffectedChildren();
        if (childrenDeltas != null && childrenDeltas.length > 0) {
            int i = 0;
            while (i < childrenDeltas.length) {
                this.processDelta(childrenDeltas[i]);
                ++i;
            }
            return;
        }
        switch (kindOfDelta) {
            case 1: {
                this.myKindOfDeltaJavaElement = 1;
                if (javaElement instanceof ICompilationUnit) {
                    try {
                        IType[] types = ((ICompilationUnit)javaElement).getTypes();
                        int i = 0;
                        while (i < types.length) {
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    break;
                }
                if (!(javaElement instanceof IMember)) break;
                this.myDeltaJavaElement = javaElement;
                break;
            }
            case 4: {
                this.myKindOfDeltaJavaElement = 4;
                if (javaElement instanceof ICompilationUnit) {
                    try {
                        IType[] types = ((ICompilationUnit)javaElement).getTypes();
                        int i = 0;
                        while (i < types.length) {
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    break;
                }
                if (!(javaElement instanceof IMember)) break;
                this.myDeltaJavaElement = javaElement;
                break;
            }
            case 2: {
                this.myKindOfDeltaJavaElement = 2;
                if (javaElement instanceof ICompilationUnit) {
                    try {
                        IType[] types = ((ICompilationUnit)javaElement).getTypes();
                        int i = 0;
                        while (i < types.length) {
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    break;
                }
                if (!(javaElement instanceof IMember)) break;
                this.myDeltaJavaElement = javaElement;
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        IJavaElement defaultPackageElement = ElementUtil.getJavaElement(this.myModel.getUniqueName(), this.myModel.getUniqueName());
        Assert.assertTrue((String)"This can't happen: it's not a package", (boolean)(defaultPackageElement instanceof IPackageFragment));
        this.myDefaultPackage = (IPackageFragment)defaultPackageElement;
        Assert.assertTrue((String)"This can't happen: it's not default", (boolean)"".equals(this.myDefaultPackage.getElementName()));
        Assert.assertTrue((String)"This can't happen: it's a jar", (!this.myDefaultPackage.isReadOnly() ? 1 : 0) != 0);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    private void clearDelta() {
        this.myDeltaJavaElement = null;
        this.myKindOfDeltaJavaElement = 0;
    }

    public class JDTDeltaTest1
    extends AbstractTest
    implements IElementChangedListener {
        public static final String NEW_FILE_NAME = "NewClass1.java";
        public static final String NEW_CLASS1_CONTENTS = "public class NewClass1 {\n}\n";
        public static final String NEW_ATTRIBUTE11_CONTENTS = "private int attribute11;\n";
        public static final String NEW_METHOD11_CONTENTS = "private int method11(int i) {\n};\n";
        public static final String NEW_CLASS2_CONTENTS = "class NewClass2 {\n}\n";
        public static final String NEW_ATTRIBUTE21_CONTENTS = "private int attribute21;\n";
        public static final String NEW_METHOD21_CONTENTS = "private int method21(int i) {\n};\n";

        public JDTDeltaTest1(String name) {
            super(name);
        }

        public void testAddRemove() throws Throwable {
            ICompilationUnit compilationUnit = DeltaTest.this.myDefaultPackage.createCompilationUnit("NewClass1.java", "", false, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)"Compilation unit not created ", (Object)compilationUnit);
            IType type1 = compilationUnit.createType("public class NewClass1 {\n}\n", null, true, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)"Type not created ", (Object)type1);
            boolean result = "NewClass1".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 1;
            Assert.assertTrue((String)"It haven't get notification about 'NewClass1' added", (boolean)result);
            this.clearDelta();
            IType type2 = compilationUnit.createType("class NewClass2 {\n}\n", null, true, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)"Type not created ", (Object)type2);
            result = "NewClass2".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 1;
            Assert.assertTrue((String)"It haven't get notification about 'NewClass2' added", (boolean)result);
            this.clearDelta();
            IField field11 = type1.createField("private int attribute11;\n", null, true, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)"IField not created ", (Object)field11);
            result = "attribute11".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 1;
            Assert.assertTrue((String)"It haven't get notification about 'attribute11' added", (boolean)result);
            this.clearDelta();
            IField field21 = type2.createField("private int attribute21;\n", null, true, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)"IField not created ", (Object)field21);
            result = "attribute21".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 1;
            Assert.assertTrue((String)"It haven't get notification about 'attribute21' added", (boolean)result);
            this.clearDelta();
            IMethod method11 = type1.createMethod("private int method11(int i) {\n};\n", null, true, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)"IMethod not created ", (Object)method11);
            result = "method11".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 1;
            Assert.assertTrue((String)"It haven't get notification about 'method11' added", (boolean)result);
            this.clearDelta();
            IMethod method21 = type2.createMethod("private int method21(int i) {\n};\n", null, true, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((String)"IMethod not created ", (Object)method21);
            result = "method21".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 1;
            Assert.assertTrue((String)"It haven't get notification about 'method21' added", (boolean)result);
            this.clearDelta();
            method11.delete(true, (IProgressMonitor)new NullProgressMonitor());
            result = "method11".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 2;
            Assert.assertTrue((String)"It haven't get notification about 'method11' deleted", (boolean)result);
            this.clearDelta();
            method21.delete(true, (IProgressMonitor)new NullProgressMonitor());
            result = "method21".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 2;
            Assert.assertTrue((String)"It haven't get notification about 'method21' deleted", (boolean)result);
            this.clearDelta();
            field11.delete(true, (IProgressMonitor)new NullProgressMonitor());
            result = "attribute11".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 2;
            Assert.assertTrue((String)"It haven't get notification about 'attribute11' deleted", (boolean)result);
            this.clearDelta();
            field21.delete(true, (IProgressMonitor)new NullProgressMonitor());
            result = "attribute21".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 2;
            Assert.assertTrue((String)"It haven't get notification about 'attribute21' deleted", (boolean)result);
            this.clearDelta();
            type1.delete(true, (IProgressMonitor)new NullProgressMonitor());
            result = "NewClass1".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 2;
            Assert.assertTrue((String)"It haven't get notification about 'NewClass1' deleted", (boolean)result);
            this.clearDelta();
            type2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            result = "NewClass2".equals(DeltaTest.this.myDeltaJavaElement.getElementName()) && DeltaTest.this.myKindOfDeltaJavaElement == 2;
            Assert.assertTrue((String)"It haven't get notification about 'NewClass2' deleted", (boolean)result);
            this.clearDelta();
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta delta = event.getDelta();
            this.processDelta(delta);
        }

        public void processDelta(IJavaElementDelta delta) {
            IJavaElement javaElement = delta.getElement();
            int kindOfDelta = delta.getKind();
            IJavaElementDelta[] childrenDeltas = delta.getAffectedChildren();
            if (childrenDeltas != null && childrenDeltas.length > 0) {
                int i = 0;
                while (i < childrenDeltas.length) {
                    this.processDelta(childrenDeltas[i]);
                    ++i;
                }
                return;
            }
            switch (kindOfDelta) {
                case 1: {
                    DeltaTest.this.myKindOfDeltaJavaElement = 1;
                    if (javaElement instanceof ICompilationUnit) {
                        try {
                            IType[] types = ((ICompilationUnit)javaElement).getTypes();
                            int i = 0;
                            while (i < types.length) {
                                ++i;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        break;
                    }
                    if (!(javaElement instanceof IMember)) break;
                    DeltaTest.this.myDeltaJavaElement = javaElement;
                    break;
                }
                case 4: {
                    DeltaTest.this.myKindOfDeltaJavaElement = 4;
                    if (javaElement instanceof ICompilationUnit) {
                        try {
                            IType[] types = ((ICompilationUnit)javaElement).getTypes();
                            int i = 0;
                            while (i < types.length) {
                                ++i;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        break;
                    }
                    if (!(javaElement instanceof IMember)) break;
                    DeltaTest.this.myDeltaJavaElement = javaElement;
                    break;
                }
                case 2: {
                    DeltaTest.this.myKindOfDeltaJavaElement = 2;
                    if (javaElement instanceof ICompilationUnit) {
                        try {
                            IType[] types = ((ICompilationUnit)javaElement).getTypes();
                            int i = 0;
                            while (i < types.length) {
                                ++i;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        break;
                    }
                    if (!(javaElement instanceof IMember)) break;
                    DeltaTest.this.myDeltaJavaElement = javaElement;
                }
            }
        }

        protected void setUp() throws Exception {
            super.setUp();
            IJavaElement defaultPackageElement = ElementUtil.getJavaElement(this.myModel.getUniqueName(), this.myModel.getUniqueName());
            Assert.assertTrue((String)"This can't happen: it's not a package", (boolean)(defaultPackageElement instanceof IPackageFragment));
            DeltaTest.this.myDefaultPackage = (IPackageFragment)defaultPackageElement;
            Assert.assertTrue((String)"This can't happen: it's not default", (boolean)"".equals(DeltaTest.this.myDefaultPackage.getElementName()));
            Assert.assertTrue((String)"This can't happen: it's a jar", (!DeltaTest.this.myDefaultPackage.isReadOnly() ? 1 : 0) != 0);
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }

        private void clearDelta() {
            DeltaTest.this.myDeltaJavaElement = null;
            DeltaTest.this.myKindOfDeltaJavaElement = 0;
        }

        public class JDTDeltaTest2
        extends AbstractTest
        implements IElementChangedListener {
            public static final String NEW_FILE_NAME = "NewClass1.java";
            public static final String NEW_CLASS1_CONTENTS = "public class NewClass1 {\n}\n";
            public static final String NEW_ATTRIBUTE11_CONTENTS = "private int attribute11;\n";
            public static final String NEW_METHOD11_CONTENTS = "private int method11(int i) {\n};\n";
            public static final String NEW_CLASS2_CONTENTS = "class NewClass2 {\n}\n";
            public static final String NEW_ATTRIBUTE21_CONTENTS = "private int attribute21;\n";
            public static final String NEW_METHOD21_CONTENTS = "private int method21(int i) {\n};\n";
            private IJavaElement myDeltaJavaElement;
            private int myKindOfDeltaJavaElement;
            private IPackageFragment myDefaultPackage;

            public JDTDeltaTest2(String name) {
                super(name);
            }

            public void testAddRemove() throws Throwable {
                ICompilationUnit compilationUnit = this.myDefaultPackage.createCompilationUnit("NewClass1.java", "", false, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((String)"Compilation unit not created ", (Object)compilationUnit);
                IType type1 = compilationUnit.createType("public class NewClass1 {\n}\n", null, true, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((String)"Type not created ", (Object)type1);
                boolean result = "NewClass1".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
                Assert.assertTrue((String)"It haven't get notification about 'NewClass1' added", (boolean)result);
                this.clearDelta();
                IType type2 = compilationUnit.createType("class NewClass2 {\n}\n", null, true, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((String)"Type not created ", (Object)type2);
                result = "NewClass2".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
                Assert.assertTrue((String)"It haven't get notification about 'NewClass2' added", (boolean)result);
                this.clearDelta();
                IField field11 = type1.createField("private int attribute11;\n", null, true, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((String)"IField not created ", (Object)field11);
                result = "attribute11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
                Assert.assertTrue((String)"It haven't get notification about 'attribute11' added", (boolean)result);
                this.clearDelta();
                IField field21 = type2.createField("private int attribute21;\n", null, true, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((String)"IField not created ", (Object)field21);
                result = "attribute21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
                Assert.assertTrue((String)"It haven't get notification about 'attribute21' added", (boolean)result);
                this.clearDelta();
                IMethod method11 = type1.createMethod("private int method11(int i) {\n};\n", null, true, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((String)"IMethod not created ", (Object)method11);
                result = "method11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
                Assert.assertTrue((String)"It haven't get notification about 'method11' added", (boolean)result);
                this.clearDelta();
                IMethod method21 = type2.createMethod("private int method21(int i) {\n};\n", null, true, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((String)"IMethod not created ", (Object)method21);
                result = "method21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 1;
                Assert.assertTrue((String)"It haven't get notification about 'method21' added", (boolean)result);
                this.clearDelta();
                method11.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = "method11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
                Assert.assertTrue((String)"It haven't get notification about 'method11' deleted", (boolean)result);
                this.clearDelta();
                method21.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = "method21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
                Assert.assertTrue((String)"It haven't get notification about 'method21' deleted", (boolean)result);
                this.clearDelta();
                field11.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = "attribute11".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
                Assert.assertTrue((String)"It haven't get notification about 'attribute11' deleted", (boolean)result);
                this.clearDelta();
                field21.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = "attribute21".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
                Assert.assertTrue((String)"It haven't get notification about 'attribute21' deleted", (boolean)result);
                this.clearDelta();
                type1.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = "NewClass1".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
                Assert.assertTrue((String)"It haven't get notification about 'NewClass1' deleted", (boolean)result);
                this.clearDelta();
                type2.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = "NewClass2".equals(this.myDeltaJavaElement.getElementName()) && this.myKindOfDeltaJavaElement == 2;
                Assert.assertTrue((String)"It haven't get notification about 'NewClass2' deleted", (boolean)result);
                this.clearDelta();
            }

            public void elementChanged(ElementChangedEvent event) {
                IJavaElementDelta delta = event.getDelta();
                this.processDelta(delta);
            }

            public void processDelta(IJavaElementDelta delta) {
                IJavaElement javaElement = delta.getElement();
                int kindOfDelta = delta.getKind();
                IJavaElementDelta[] childrenDeltas = delta.getAffectedChildren();
                if (childrenDeltas != null && childrenDeltas.length > 0) {
                    int i = 0;
                    while (i < childrenDeltas.length) {
                        this.processDelta(childrenDeltas[i]);
                        ++i;
                    }
                    return;
                }
                switch (kindOfDelta) {
                    case 1: {
                        this.myKindOfDeltaJavaElement = 1;
                        if (javaElement instanceof ICompilationUnit) {
                            try {
                                IType[] types = ((ICompilationUnit)javaElement).getTypes();
                                int i = 0;
                                while (i < types.length) {
                                    ++i;
                                }
                            }
                            catch (JavaModelException javaModelException) {}
                            break;
                        }
                        if (!(javaElement instanceof IMember)) break;
                        this.myDeltaJavaElement = javaElement;
                        break;
                    }
                    case 4: {
                        this.myKindOfDeltaJavaElement = 4;
                        if (javaElement instanceof ICompilationUnit) {
                            try {
                                IType[] types = ((ICompilationUnit)javaElement).getTypes();
                                int i = 0;
                                while (i < types.length) {
                                    ++i;
                                }
                            }
                            catch (JavaModelException javaModelException) {}
                            break;
                        }
                        if (!(javaElement instanceof IMember)) break;
                        this.myDeltaJavaElement = javaElement;
                        break;
                    }
                    case 2: {
                        this.myKindOfDeltaJavaElement = 2;
                        if (javaElement instanceof ICompilationUnit) {
                            try {
                                IType[] types = ((ICompilationUnit)javaElement).getTypes();
                                int i = 0;
                                while (i < types.length) {
                                    ++i;
                                }
                            }
                            catch (JavaModelException javaModelException) {}
                            break;
                        }
                        if (!(javaElement instanceof IMember)) break;
                        this.myDeltaJavaElement = javaElement;
                    }
                }
            }

            protected void setUp() throws Exception {
                super.setUp();
                IJavaElement defaultPackageElement = ElementUtil.getJavaElement(this.myModel.getUniqueName(), this.myModel.getUniqueName());
                Assert.assertTrue((String)"This can't happen: it's not a package", (boolean)(defaultPackageElement instanceof IPackageFragment));
                this.myDefaultPackage = (IPackageFragment)defaultPackageElement;
                Assert.assertTrue((String)"This can't happen: it's not default", (boolean)"".equals(this.myDefaultPackage.getElementName()));
                Assert.assertTrue((String)"This can't happen: it's a jar", (!this.myDefaultPackage.isReadOnly() ? 1 : 0) != 0);
                JavaCore.addElementChangedListener((IElementChangedListener)this);
            }

            protected void tearDown() throws Exception {
                super.tearDown();
                JavaCore.removeElementChangedListener((IElementChangedListener)this);
            }

            private void clearDelta() {
                this.myDeltaJavaElement = null;
                this.myKindOfDeltaJavaElement = 0;
            }
        }
    }
}

