/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.test;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;

public class AbstractTest
extends TestCase {
    protected Model myModel;
    protected IProject myProject;
    protected IJavaProject myJavaProject;

    public AbstractTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.myProject = ResourcesPlugin.getWorkspace().getRoot().getProject("testProject" + Math.random());
        if (!this.myProject.exists()) {
            this.myProject.create(null);
        }
        if (!this.myProject.isOpen()) {
            this.myProject.open(null);
        }
        if (!this.myProject.hasNature("org.eclipse.jdt.core.javanature")) {
            this.addNatureToProject("org.eclipse.jdt.core.javanature");
        }
        this.myJavaProject = JavaCore.create((IProject)this.myProject);
        UniqueName uniqueName = ModelAccess.createModelUniqueName((String)this.myJavaProject.getProject().getName());
        this.myModel = ModelAccess.createModel((UniqueName)uniqueName);
    }

    protected void tearDown() throws Exception {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (AbstractTest.this.myModel != null) {
                        AbstractTest.this.myModel.delete();
                    }
                    AbstractTest.this.myJavaProject.getProject().delete(true, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected IJavaProject getJavaProject() {
        return this.myJavaProject;
    }

    protected Model getModel() {
        return this.myModel;
    }

    protected void addNatureToProject(String natureId) throws Exception {
        IProjectDescription description = this.myProject.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        this.myProject.setDescription(description, null);
    }

    protected void appendRTJar() throws Exception {
        IClasspathEntry rtJarEntry;
        File javaHome = new File(System.getProperty("java.home"));
        File rtJar = new File(javaHome, "jre" + File.separator + "lib" + File.separator + "rt.jar");
        if (!rtJar.exists()) {
            rtJar = new File(javaHome, "lib" + File.separator + "rt.jar");
        }
        IClasspathEntry[] oldClasspath = this.myJavaProject.getRawClasspath();
        IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length + 1];
        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
        newClasspath[oldClasspath.length] = rtJarEntry = JavaCore.newLibraryEntry((IPath)new Path(rtJar.getAbsolutePath()), null, null);
        this.myJavaProject.setRawClasspath(newClasspath, null);
    }

    protected void removeRTJar() throws Exception {
        IClasspathEntry[] newClasspath = new IClasspathEntry[]{};
        this.myJavaProject.setRawClasspath(newClasspath, null);
    }
}

