/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.resources;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ProjectUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContent;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class SingleCompilationUnitContent
implements IPackageContent {
    private ICompilationUnit myCompilationUnit;
    private String myName;
    private String myOriginalPackageNameWithDot;
    private List myImportStrings;
    private ISourceRange myImportsSourceRange;
    private ISourceRange[] myPackageSourceRanges;
    private String myContents;
    private boolean myImportsNotResolved;
    private boolean myPackageDeclarationNotResolved;
    private boolean myShouldCreateMovedDeltaOnPaste;
    private UniqueName myOriginalUin;

    public SingleCompilationUnitContent(ICompilationUnit compilationUnit, boolean wasCut) throws JavaModelException {
        this.myShouldCreateMovedDeltaOnPaste = wasCut;
        this.myOriginalUin = SingleCompilationUnitContent.getTypeUniqueName(compilationUnit);
        this.myCompilationUnit = compilationUnit;
        if (!this.myCompilationUnit.isConsistent()) {
            this.myCompilationUnit.makeConsistent((IProgressMonitor)new NullProgressMonitor());
        }
        this.myName = this.myCompilationUnit.getElementName();
        this.myOriginalPackageNameWithDot = this.myCompilationUnit.getParent().getElementName() + '.';
        this.initContents();
        this.initPackageDeclaration();
        this.initImportStrings();
    }

    public boolean canPaste(IPackageFragment newPackageFragment) {
        if (newPackageFragment == null || !newPackageFragment.exists()) {
            return false;
        }
        ICompilationUnit alreadyExists = newPackageFragment.getCompilationUnit(this.myName);
        return alreadyExists == null || !alreadyExists.exists();
    }

    public void paste(IPackageFragment newPackageFragment, Map collectedSubstitutionMap) {
        ICompilationUnit pastedResult = null;
        try {
            String newContents = this.computeNewSource(newPackageFragment);
            pastedResult = newPackageFragment.createCompilationUnit(this.myName, newContents, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            pastedResult = null;
            e.printStackTrace();
        }
        if (pastedResult != null && this.myOriginalUin != null) {
            IType pastedMainType = null;
            try {
                pastedMainType = SingleCompilationUnitContent.getMainType(pastedResult);
            }
            catch (JavaModelException cantFindMainType) {
                cantFindMainType.printStackTrace();
            }
            if (pastedMainType != null) {
                this.collectSubstitutedUins(pastedMainType, collectedSubstitutionMap);
                this.addMovedClassDelta(pastedMainType);
            }
        }
    }

    private void initImportStrings() {
        try {
            IImportContainer importContainer;
            IImportDeclaration[] imports = this.myCompilationUnit.getImports();
            if (imports != null && imports.length > 0) {
                this.myImportStrings = new LinkedList();
                int i = 0;
                while (i < imports.length) {
                    IImportDeclaration cur = imports[i];
                    this.myImportStrings.add(cur.getElementName());
                    ++i;
                }
            }
            this.myImportsSourceRange = (importContainer = this.myCompilationUnit.getImportContainer()).exists() ? importContainer.getSourceRange() : null;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            this.myImportsNotResolved = true;
            this.myImportsSourceRange = null;
        }
    }

    private void initPackageDeclaration() {
        try {
            IPackageDeclaration[] declarations = this.myCompilationUnit.getPackageDeclarations();
            if (declarations != null && declarations.length > 0) {
                this.myPackageSourceRanges = new ISourceRange[declarations.length];
                int i = 0;
                while (i < declarations.length) {
                    this.myPackageSourceRanges[i] = declarations[i].getSourceRange();
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            this.myPackageSourceRanges = null;
            this.myPackageDeclarationNotResolved = true;
        }
    }

    private void initContents() throws JavaModelException {
        this.myContents = this.myCompilationUnit.getBuffer().getContents();
    }

    public String computeNewSource(IPackageFragment targetPackage) {
        StringBuffer result = new StringBuffer(this.myContents.length() + 100);
        int lastUsedIndex = this.computeNewPackageDeclaration(result, targetPackage);
        lastUsedIndex = this.computeNewImports(result, targetPackage, lastUsedIndex);
        result.append(this.myContents.substring(lastUsedIndex));
        return result.toString();
    }

    private int computeNewPackageDeclaration(StringBuffer result, IPackageFragment targetPackage) {
        if (this.myPackageDeclarationNotResolved || this.myPackageSourceRanges == null) {
            this.appendTargetPackageDeclaration(result, targetPackage);
            result.append(JavaProviderPlugin.EOL);
            return 0;
        }
        int lastProcessedIndex = 0;
        int i = 0;
        while (i < this.myPackageSourceRanges.length) {
            ISourceRange curRange = this.myPackageSourceRanges[i];
            result.append(this.myContents.substring(lastProcessedIndex, curRange.getOffset()));
            if (i == 0) {
                this.appendTargetPackageDeclaration(result, targetPackage);
            }
            lastProcessedIndex += curRange.getOffset() + curRange.getLength();
            ++i;
        }
        return lastProcessedIndex;
    }

    private int computeNewImports(StringBuffer result, IPackageFragment targetPackage, int lastProcessedIndex) {
        if (this.myImportsNotResolved || this.myImportsSourceRange == null) {
            return lastProcessedIndex;
        }
        result.append(this.myContents.substring(lastProcessedIndex, this.myImportsSourceRange.getOffset()));
        if (this.myImportStrings != null) {
            Iterator imports = this.myImportStrings.iterator();
            while (imports.hasNext()) {
                String curOldImport = (String)imports.next();
                this.appendSingleImport(result, curOldImport, targetPackage);
                if (!imports.hasNext()) continue;
                result.append(JavaProviderPlugin.EOL);
            }
        }
        return this.myImportsSourceRange.getOffset() + this.myImportsSourceRange.getLength();
    }

    private void appendSingleImport(StringBuffer result, String originalImport, IPackageFragment targetPackage) {
        result.append("import ");
        if (originalImport.startsWith(this.myOriginalPackageNameWithDot)) {
            result.append(targetPackage.getElementName());
            if (!targetPackage.isDefaultPackage()) {
                result.append('.');
            }
            result.append(originalImport.substring(this.myOriginalPackageNameWithDot.length()));
        } else {
            result.append(originalImport);
        }
        result.append(";");
    }

    private void appendTargetPackageDeclaration(StringBuffer result, IPackageFragment targetPackage) {
        if (!targetPackage.isDefaultPackage()) {
            result.append("package ");
            result.append(targetPackage.getElementName());
            result.append(';');
        }
    }

    private IType getPastedMainType(ICompilationUnit pastedCU) {
        IType result = null;
        try {
            if (!pastedCU.isConsistent()) {
                pastedCU.makeConsistent((IProgressMonitor)new NullProgressMonitor());
            }
            result = SingleCompilationUnitContent.getMainType(pastedCU);
        }
        catch (JavaModelException canNotFindType) {
            System.err.println("can not find main type after pasting: " + this.myName);
            canNotFindType.printStackTrace();
        }
        return result;
    }

    private void collectSubstitutedUins(IType pastedMainType, Map result) {
        Element pastedMainElement;
        Assert.isLegal((pastedMainType != null ? 1 : 0) != 0);
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)pastedMainType.getJavaProject().getProject());
        if (modelUin != null && (pastedMainElement = ElementUtil.getModelElement(modelUin, (IJavaElement)pastedMainType)) != null) {
            result.put(this.myOriginalUin, pastedMainElement);
            UniqueName pastedTypeUin = pastedMainElement.getUniqueName();
            IJavaElement[] members = null;
            try {
                members = pastedMainType.getChildren();
            }
            catch (JavaModelException canNotAccessPastedMembers) {
                System.err.println("can not access pasted members after pasting: " + this.myName);
                return;
            }
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    IJavaElement next = members[i];
                    if (next instanceof IMember) {
                        Element pastedModelElement = ElementUtil.getModelElement(modelUin, next);
                        UniqueName nextOldUin = NameUtil.getOldMemberUniqueName(this.myOriginalUin, pastedTypeUin, (IMember)next);
                        if (pastedModelElement instanceof Entity && nextOldUin != null) {
                            result.put(nextOldUin, pastedModelElement);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void addMovedClassDelta(IType pastedMainType) {
        if (this.myShouldCreateMovedDeltaOnPaste && pastedMainType != null) {
            IJavaProject[] javaProjects = ProjectUtil.getReferencingProjects(pastedMainType.getJavaProject());
            int i = 0;
            while (i < javaProjects.length) {
                Element pastedMainElement;
                IJavaProject javaProject = javaProjects[i];
                UniqueName modelUin = ModelUinSupport.createModelUin((IResource)javaProject.getProject());
                Model model = ModelAccess.getModel((UniqueName)modelUin);
                if (modelUin != null && (pastedMainElement = ElementUtil.getModelElement(modelUin, (IJavaElement)pastedMainType)) != null) {
                    UniqueName newUniqueName = pastedMainElement.getUniqueName();
                    UniqueName oldUniqueName = this.myOriginalUin;
                    if (javaProject.getElementName().equals(pastedMainType.getJavaProject().getElementName())) {
                        DeltaPatcherTreeProvider.putAdditionalMovedDelta(model, oldUniqueName, newUniqueName);
                    } else {
                        newUniqueName = ModelAccess.createUniqueName((String)newUniqueName.getDomain(), (String)newUniqueName.getSubDomain(), (String)"ref", (String)newUniqueName.getName(), (String[])this.getParameters(newUniqueName));
                        oldUniqueName = ModelAccess.createUniqueName((String)oldUniqueName.getDomain(), (String)oldUniqueName.getSubDomain(), (String)"ref", (String)oldUniqueName.getName(), (String[])this.getParameters(oldUniqueName));
                        DeltaPatcherTreeProvider.putAdditionalMovedDelta(model, oldUniqueName, newUniqueName);
                    }
                }
                DeltaPatcherTreeProvider.modelChanged(model);
                ++i;
            }
        }
    }

    private String[] getParameters(UniqueName uniqueName) {
        int count = uniqueName.getParametersCount();
        String[] sta = new String[count];
        int i = 0;
        while (i < sta.length) {
            sta[i] = uniqueName.getParameter(i);
            ++i;
        }
        return sta;
    }

    private static IType getMainType(ICompilationUnit cu) throws JavaModelException {
        IType[] types;
        if (cu == null) {
            return null;
        }
        if (!cu.isConsistent()) {
            cu.makeConsistent((IProgressMonitor)new NullProgressMonitor());
        }
        return (types = cu.getTypes()) != null && types.length > 0 ? types[0] : null;
    }

    private static UniqueName getTypeUniqueName(ICompilationUnit cu) throws JavaModelException {
        IType mainType = SingleCompilationUnitContent.getMainType(cu);
        return mainType == null ? null : NameUtil.getTypeUniqueName(cu.getJavaProject(), mainType);
    }
}

