/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.resources;

import com.tssap.selena.internal.core.providers.java.refactor.PackageFragmentReferenceFinder;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContent;
import com.tssap.selena.internal.core.providers.java.resources.SingleCompilationUnitContent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class PackageFragmentContent
implements IPackageContent {
    private IPackageFragment myOriginalPackage;
    private HashSet myCompilationUnits;
    private PackageFragmentReferenceFinder myExternalUsageFinder;

    public PackageFragmentContent(IPackageFragment original, boolean updateExternalUsages) throws JavaModelException {
        this.myOriginalPackage = original;
        ICompilationUnit[] units = this.myOriginalPackage.getCompilationUnits();
        this.myCompilationUnits = new HashSet((units.length + 1) * 2);
        int i = 0;
        while (i < units.length) {
            SingleCompilationUnitContent curContent = new SingleCompilationUnitContent(units[i], updateExternalUsages);
            this.myCompilationUnits.add(curContent);
            ++i;
        }
        if (updateExternalUsages) {
            this.myExternalUsageFinder = new PackageFragmentReferenceFinder(original);
            this.myExternalUsageFinder.setExcludingBase(original);
            this.myExternalUsageFinder.find();
        }
    }

    public boolean canPaste(IPackageFragment newPackageFragment) {
        if (newPackageFragment == null || !newPackageFragment.exists()) {
            return false;
        }
        boolean result = true;
        Iterator units = this.myCompilationUnits.iterator();
        while (result && units.hasNext()) {
            IPackageContent curContent = (IPackageContent)units.next();
            result = curContent.canPaste(newPackageFragment);
        }
        return result;
    }

    public void paste(IPackageFragment newPackageFragment, Map collectedSubstitutionMap) {
        Iterator units = this.myCompilationUnits.iterator();
        while (units.hasNext()) {
            IPackageContent curContent = (IPackageContent)units.next();
            curContent.paste(newPackageFragment, collectedSubstitutionMap);
        }
        if (this.myExternalUsageFinder != null) {
            this.myExternalUsageFinder.replaceBy(newPackageFragment);
        }
    }
}

