/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.resources;

import com.tssap.selena.internal.core.providers.java.resources.CompositePackageContent;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContent;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContentFactory;
import com.tssap.selena.internal.core.providers.java.resources.JavaRootProvider;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootCopyPaster;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IPackageFragment;

public class PackageContentClipboard
implements IRootCopyPaster {
    private HashMap myContents = new HashMap();
    private final JavaRootProvider myRootProvider;
    private static PackageContentClipboard ourInstance;
    private static List ourFactories;

    PackageContentClipboard(JavaRootProvider rootProvider) {
        this.myRootProvider = rootProvider;
    }

    public static void registerFactory(IPackageContentFactory factory) {
        ourFactories.add(factory);
    }

    public static void unregisterAllFactories() {
        ourFactories.clear();
    }

    public boolean canCopy(IProjectRelativePath fromPath) {
        return this.myRootProvider.toPackageFragment(fromPath) != null;
    }

    public boolean canCut(IProjectRelativePath fromPath) {
        return this.canCopy(fromPath);
    }

    public void copy(IProjectRelativePath path) {
        this.savePackageContent(path, this.myRootProvider.toPackageFragment(path), false);
    }

    public void cut(IProjectRelativePath path) {
        this.savePackageContent(path, this.myRootProvider.toPackageFragment(path), true);
    }

    public void disposeCopy(IProjectRelativePath path) {
        this.removePackageContent(path);
    }

    public boolean canPaste(IProjectRelativePath from, IProjectRelativePath toPath) {
        IPackageContent content = this.getPackageContent(from);
        if (content == null) {
            return false;
        }
        IPackageFragment targetPF = this.myRootProvider.toPackageFragment(toPath);
        return targetPF != null && targetPF.exists() && content.canPaste(targetPF);
    }

    public void pasteBase(IProjectRelativePath from, IProjectRelativePath toPath, Map collectedSubstitutionMap) {
        IPackageContent content = this.getPackageContent(from);
        IPackageFragment targetPF = this.myRootProvider.toPackageFragment(toPath, true);
        content.paste(targetPF, collectedSubstitutionMap);
    }

    public void pasteDerived(IProjectRelativePath from, IProjectRelativePath toPath, Map collectedSubstitutionMap) {
    }

    public void pasteTertiary(IProjectRelativePath from, IProjectRelativePath toPath, Map collectedSubstitutionMap) {
    }

    private void savePackageContent(IProjectRelativePath packagePath, IPackageFragment packageFragment, boolean collectExternalUsages) {
        if (packagePath == null || packageFragment == null || !packageFragment.exists()) {
            return;
        }
        CompositePackageContent compositeContent = new CompositePackageContent();
        Iterator factories = ourFactories.iterator();
        while (factories.hasNext()) {
            IPackageContent next = ((IPackageContentFactory)factories.next()).createPackageContent(packagePath, packageFragment, collectExternalUsages);
            if (next == null) continue;
            compositeContent.addContent(next);
        }
        this.myContents.put(packagePath, compositeContent);
    }

    private IPackageContent getPackageContent(IProjectRelativePath packagePath) {
        return (IPackageContent)this.myContents.get(packagePath);
    }

    private IPackageContent removePackageContent(IProjectRelativePath packagePath) {
        return (IPackageContent)this.myContents.remove(packagePath);
    }

    static {
        ourFactories = new LinkedList();
    }
}

