/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.resources;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.PackageFragmentRootListener;
import com.tssap.selena.internal.core.providers.java.resources.JavaRootProvider;
import com.tssap.selena.model.providers.resources.IRootProvider;
import com.tssap.selena.model.providers.resources.IRootProviderFactory;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaRootProviderFactory
implements IRootProviderFactory {
    private static PackageFragmentRootListener ourRootReloader;

    public JavaRootProviderFactory() {
        if (ourRootReloader == null) {
            ourRootReloader = new PackageFragmentRootListener();
        }
    }

    public IRootProvider[] createRootProviders(IProject project) {
        HashSet<JavaRootProvider> result = new HashSet<JavaRootProvider>();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i];
                    if (packageFragmentRoot.getKind() == 1 && javaProject.equals(packageFragmentRoot.getJavaProject())) {
                        JavaRootProvider rootProvider = new JavaRootProvider(project, packageFragmentRoot);
                        result.add(rootProvider);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            result.clear();
        }
        catch (CoreException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            result.clear();
        }
        return ((AbstractCollection)result).toArray(new IRootProvider[result.size()]);
    }
}

