/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.resources;

import com.tssap.selena.internal.core.providers.java.refactor.RefactorPerformer;
import com.tssap.selena.internal.core.providers.java.refactor.RenameRefactoringFactory;
import com.tssap.selena.internal.core.providers.java.resources.PackageContentClipboard;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootCopyPaster;
import com.tssap.selena.model.providers.resources.IRootProvider;
import com.tssap.selena.model.util.Assert;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;

public class JavaRootProvider
implements IRootProvider {
    private IPackageFragmentRoot myPackageFragmentRoot;
    private IPath myRootPath;
    private IProject myProject;
    private PackageContentClipboard myClipboard;

    JavaRootProvider(IProject project, IPackageFragmentRoot packageFragmentRoot) {
        this.myProject = project;
        this.myPackageFragmentRoot = packageFragmentRoot;
        this.myRootPath = packageFragmentRoot.getResource().getProjectRelativePath();
    }

    public void registered(IProject project) {
        Assert.isLegal((boolean)project.getName().equals(this.myProject.getName()));
    }

    public void unregistered(IProject project) {
        Assert.isLegal((boolean)project.getName().equals(this.myProject.getName()));
    }

    public String getID() {
        return "com.tssap.selena.java_root";
    }

    public IPath getRootPath() {
        return this.myRootPath;
    }

    public boolean isValidFolder(IProjectRelativePath path) {
        if (this.myPackageFragmentRoot.exists()) {
            if (this.myRootPath == path) {
                return true;
            }
            if (path.toString().indexOf(".") != -1) {
                return false;
            }
            String packageName = this.extractPackageName(this.myRootPath, (IPath)path);
            if ("".equals(packageName)) {
                return true;
            }
            IStatus status = JavaConventions.validatePackageName((String)packageName);
            return status.getSeverity() != 4;
        }
        return false;
    }

    private String extractPackageName(IPath rootPath, IPath projectRelativePath) {
        String sRootPath;
        String sProjectRelativePath = projectRelativePath.toString();
        if (sProjectRelativePath.equals(sRootPath = rootPath.toString())) {
            return "";
        }
        if (sProjectRelativePath.startsWith(sRootPath)) {
            String sRootRelativePath = sProjectRelativePath.substring(sRootPath.length());
            sRootRelativePath = sRootRelativePath.replace('/', '.');
            sRootRelativePath = sRootRelativePath.replace('\\', '.');
            while (sRootRelativePath.startsWith(".")) {
                sRootRelativePath = sRootRelativePath.substring(1);
            }
            return sRootRelativePath;
        }
        return null;
    }

    public IRootProvider.ConsistencyType shouldBeConsistent() {
        return IRootProvider.ConsistencyType.CONSISTENT_BY_GROUP;
    }

    public boolean rename(IProjectRelativePath fromPath, IProjectRelativePath destPath) {
        if (!this.canRename(fromPath, destPath)) {
            return false;
        }
        Assert.isLegal((!fromPath.isEmpty() && !fromPath.equals((Object)this.myRootPath) ? 1 : 0) != 0, (String)("illegal: " + fromPath));
        Assert.isLegal((boolean)fromPath.removeLastSegments(1).equals((Object)destPath.removeLastSegments(1)), (String)("illegal pair: " + fromPath + " vs: " + destPath));
        IPackageFragment fragment = this.toPackageFragment(fromPath);
        Assert.isLegal((fragment != null && fragment.exists() ? 1 : 0) != 0);
        String packageName = this.extractPackageName(this.myRootPath, (IPath)fromPath);
        int lastDot = packageName.lastIndexOf(".");
        String newName = fragment.getElementName().substring(0, lastDot + 1) + destPath.lastSegment();
        final RenamePackageOperation renameOperation = new RenamePackageOperation(this.myPackageFragmentRoot, fragment, newName);
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    renameOperation.run(monitor);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean canRename(IProjectRelativePath fromPath, IProjectRelativePath destPath) {
        if (fromPath.equals((Object)this.myRootPath)) {
            return false;
        }
        if (!fromPath.removeLastSegments(1).equals((Object)destPath.removeLastSegments(1))) {
            return false;
        }
        String packageName = this.extractPackageName(this.myRootPath, (IPath)fromPath);
        IPackageFragment fragment = this.myPackageFragmentRoot.getPackageFragment(packageName);
        if (fragment == null || !fragment.exists()) {
            return false;
        }
        return RenameRefactoringFactory.getRenameRefactoring((IJavaElement)fragment) != null;
    }

    public IRootCopyPaster getCopyPaster() {
        return this.getClipboard();
    }

    IPackageFragment toPackageFragment(IProjectRelativePath projectRelativePath) {
        return this.toPackageFragment(projectRelativePath, false);
    }

    IPackageFragment toPackageFragment(IProjectRelativePath projectRelativePath, boolean forceCreation) {
        String packageName = this.extractPackageName(this.myRootPath, (IPath)projectRelativePath);
        IPackageFragment fragment = this.myPackageFragmentRoot.getPackageFragment(packageName);
        if (fragment != null && !fragment.exists() && forceCreation) {
            try {
                this.myPackageFragmentRoot.createPackageFragment(packageName, true, null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return fragment.exists() ? fragment : null;
    }

    private PackageContentClipboard getClipboard() {
        if (this.myClipboard == null) {
            this.myClipboard = new PackageContentClipboard(this);
        }
        return this.myClipboard;
    }

    private static class RenamePackageOperation
    extends JavaModelOperation {
        private IPackageFragment myPackageFragment;
        private String myNewName;
        private IPackageFragmentRoot myRoot;

        public RenamePackageOperation(IPackageFragmentRoot root, IPackageFragment baseFragment, String baseNewName) {
            super(RenamePackageOperation.getAffectedFragments(root, baseFragment, baseNewName));
            this.myPackageFragment = baseFragment;
            this.myNewName = baseNewName;
        }

        private static IJavaElement[] getAffectedFragments(IPackageFragmentRoot root, IPackageFragment baseFragment, String baseNewName) {
            IJavaElement[] fragments;
            LinkedList<IPackageFragment> result = new LinkedList<IPackageFragment>();
            String baseFragmentName = baseFragment.getElementName();
            String baseNameWithDot = baseFragmentName + '.';
            try {
                fragments = root.getChildren();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                return new IJavaElement[0];
            }
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment curFragment;
                String curName;
                IJavaElement cur = fragments[i];
                if (cur.getElementType() == 4 && ((curName = (curFragment = (IPackageFragment)cur).getElementName()).equals(baseFragmentName) || curName.startsWith(baseNameWithDot))) {
                    result.add(curFragment);
                }
                ++i;
            }
            return result.toArray(new IJavaElement[result.size()]);
        }

        protected void executeOperation() throws JavaModelException {
            String baseFragmentName = this.myPackageFragment.getElementName();
            TreeSet<IJavaElement> reverseSortedFragments = new TreeSet<IJavaElement>(new Comparator(this){
                private final /* synthetic */ RenamePackageOperation this$0;
                {
                    this.this$0 = this$0;
                }

                public int compare(Object o1, Object o2) {
                    return -((IJavaElement)o1).getElementName().compareTo(((IJavaElement)o2).getElementName());
                }
            });
            reverseSortedFragments.addAll(Arrays.asList(this.getElementsToProcess()));
            Iterator reverseIt = reverseSortedFragments.iterator();
            while (reverseIt.hasNext()) {
                IPackageFragment cur = (IPackageFragment)reverseIt.next();
                String curName = cur.getElementName();
                Assert.isLegal((boolean)curName.startsWith(baseFragmentName), (String)("illegal fragment: " + cur.getElementName()));
                String curNewName = this.myNewName + curName.substring(baseFragmentName.length());
                RenamePackageOperation.primRenamePackageFragment(cur, curNewName);
            }
        }

        private static boolean primRenamePackageFragment(IPackageFragment packageFragment, String newName) {
            IRenameRefactoring refactoring = RenameRefactoringFactory.getRenameRefactoring((IJavaElement)packageFragment);
            if (refactoring == null) {
                return false;
            }
            return RefactorPerformer.perform(refactoring, newName, true);
        }
    }
}

