/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.references;

import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class RefTypeASTVisitor
extends ASTVisitor {
    private boolean myIncludeJavaLang;
    private Set myOnDemandImports = new HashSet();
    private Set mySingleImports = new HashSet();
    private Set myResolvedBindings = new HashSet();
    private Set myUnknownBindings = new HashSet();

    public RefTypeASTVisitor() {
        this(false);
    }

    public RefTypeASTVisitor(boolean includeJavaLang) {
        this.myIncludeJavaLang = includeJavaLang;
    }

    public String[] getResolvedBindings(IType type) {
        Iterator notResolved = this.myUnknownBindings.iterator();
        while (notResolved.hasNext()) {
            String typeName = (String)notResolved.next();
            String fqn = TypeNameResolver.resolveTypeName(type, typeName);
            if (fqn == null) continue;
            notResolved.remove();
            this.myResolvedBindings.add(fqn);
        }
        return this.myResolvedBindings.toArray(new String[this.myResolvedBindings.size()]);
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            this.collectTypeBinding((ITypeBinding)binding);
        }
        return false;
    }

    public boolean visit(QualifiedName node) {
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        if (node.isOnDemand()) {
            this.myOnDemandImports.add(node.getName());
        } else {
            this.mySingleImports.add(node.getName());
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.visitChild((ASTNode)node.getSuperclass());
        this.visitChildren(node.superInterfaces());
        this.visitChildren(node.bodyDeclarations());
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        this.visitChild((ASTNode)node.getReturnType());
        this.visitChildren(node.parameters());
        this.visitChildren(node.thrownExceptions());
        this.visitChild((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.visitChild((ASTNode)node.getExpression());
        this.visitChildren(node.arguments());
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.collectVariableDeclaration((VariableDeclaration)node);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.collectVariableDeclaration((VariableDeclaration)node);
        return false;
    }

    private void collectVariableDeclaration(VariableDeclaration declaration) {
        IVariableBinding variable = declaration.resolveBinding();
        if (variable != null) {
            this.collectTypeBinding(variable.getType());
        }
    }

    private boolean shouldBeSkipped(IPackageBinding binding) {
        return binding != null && !this.myIncludeJavaLang && "java.lang".equals(binding.getName());
    }

    private void collectTypeBinding(ITypeBinding typeBinding) {
        if (typeBinding == null || typeBinding.isPrimitive()) {
            return;
        }
        String name = typeBinding.getName();
        IPackageBinding packageBinding = typeBinding.getPackage();
        if (this.shouldBeSkipped(packageBinding)) {
            return;
        }
        if (packageBinding != null) {
            String fqn = packageBinding.isUnnamed() ? name : packageBinding.getName() + "." + name;
            this.myResolvedBindings.add(fqn);
        } else {
            this.myUnknownBindings.add(name);
        }
    }

    private void visitChildren(List children) {
        if (children == null) {
            return;
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ((ASTNode)it.next()).accept((ASTVisitor)this);
        }
    }

    private void visitChild(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }
}

