/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.references;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.references.FindASTNode;
import com.tssap.selena.internal.core.providers.java.references.RefTypeASTVisitor;
import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class OutgoingReferences {
    public static String[] getOutgoingReferences(ICompilationUnit compilationUnit, IMember member) {
        try {
            AST ast = new AST();
            CompilationUnit astCompilationUnit = AST.parseCompilationUnit((ICompilationUnit)compilationUnit, (boolean)true);
            String[] bindings = new String[]{};
            RefTypeASTVisitor astVisitor = new RefTypeASTVisitor();
            if (member != null) {
                return OutgoingReferences.getTypeOutgoingReferences(astCompilationUnit, astVisitor, member);
            }
            ArrayList list = new ArrayList();
            IType[] types = compilationUnit.getTypes();
            int i = 0;
            while (i < types.length) {
                IType type = types[i];
                Object[] arr = OutgoingReferences.getTypeOutgoingReferences(astCompilationUnit, astVisitor, (IMember)type);
                list.addAll(ArrayUtil.toList(arr));
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return new String[0];
        }
    }

    private static String[] getTypeOutgoingReferences(CompilationUnit astCompilationUnit, RefTypeASTVisitor astVisitor, IMember member) {
        ASTNode astNode;
        if (member != null && member.exists() && (astNode = FindASTNode.findASTNode(astCompilationUnit, member)) != null) {
            astNode.accept((ASTVisitor)astVisitor);
            IType type = member instanceof IType ? (IType)member : member.getDeclaringType();
            Object[] resolvedBindings = astVisitor.getResolvedBindings(type);
            int index = ArrayUtil.getIndex(resolvedBindings, type.getFullyQualifiedName());
            if (index != -1) {
                resolvedBindings = ArrayUtil.remove((String[])resolvedBindings, index);
            }
            return resolvedBindings;
        }
        return new String[0];
    }
}

