/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor.design;

import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.nodeset.CachedDesignModelScope;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.dom.search.IDesignSearchScope;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.refactor.design.MultipleLinkFinder;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.RenameHandler;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class RenameTargetClassHandler
implements RenameHandler,
ModelAware {
    private UniqueName myModelUin;

    public void handleRename(UniqueName originalUniqueName, UniqueName newUniqueName) {
        NodeSetCache cache;
        if (originalUniqueName == null || newUniqueName == null || originalUniqueName.equals(newUniqueName)) {
            return;
        }
        Model model = ModelAccess.getModel((UniqueName)this.myModelUin);
        if (model == null || model.isDeleted()) {
            System.err.println("Model is not accessible: " + this.myModelUin);
            return;
        }
        Element newElement = model.findElement(newUniqueName);
        if (newElement == null || newElement.isDeleted()) {
            return;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(newElement);
        final Map substitutionMap = javaElement instanceof IType ? this.createSubstitutionMap((IType)javaElement, newUniqueName, originalUniqueName) : Collections.singletonMap(originalUniqueName.toString(), newUniqueName.toString());
        final DesignLink[] incomingLinks = new MultipleLinkFinder(substitutionMap).find((IDesignSearchScope)new CachedDesignModelScope(cache = NodeSetCache.getCache((UniqueName)this.myModelUin)));
        if (incomingLinks == null || incomingLinks.length == 0) {
            return;
        }
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                int i = 0;
                while (i < incomingLinks.length) {
                    DesignLink next = incomingLinks[i];
                    next.createTarget((String)substitutionMap.get(next.getTarget().getProxyId()));
                    ++i;
                }
            }
        });
    }

    public void registered(Model model) {
        this.myModelUin = model.getUniqueName();
    }

    public void unregistered(Model model) {
        if (model.getUniqueName().equals(this.myModelUin)) {
            this.myModelUin = null;
        } else {
            System.err.println("ATTENTION: RenameTargetClassHandler: registered for : " + this.myModelUin + "\n unregistered for : " + model.getUniqueName());
        }
    }

    private Map createSubstitutionMap(IType type, UniqueName newTypeUin, UniqueName oldTypeUin) {
        HashMap<String, String> result = new HashMap<String, String>();
        LinkedList<Object> members = new LinkedList<Object>();
        try {
            members.addAll(Arrays.asList(type.getTypes()));
            members.addAll(Arrays.asList(type.getMethods()));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            members.clear();
        }
        IJavaProject javaProject = ElementUtil.getJavaProject(this.myModelUin);
        Iterator it = members.iterator();
        while (it.hasNext()) {
            IMember next = (IMember)it.next();
            UniqueName oldMemberUin = NameUtil.getOldMemberUniqueName(oldTypeUin, newTypeUin, next);
            UniqueName newMemberUin = NameUtil.getJavaElementUniqueName(javaProject, (IJavaElement)next);
            if (oldMemberUin == null || newMemberUin == null) continue;
            result.put(oldMemberUin.toString(), newMemberUin.toString());
        }
        result.put(oldTypeUin.toString(), newTypeUin.toString());
        return result;
    }
}

