/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor.comments;

import com.tssap.selena.internal.core.providers.java.refactor.comments.SafeIO;
import com.tssap.selena.model.util.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;

class SearchResultCollectorReplacer
implements ITextSearchResultCollector {
    private HashMap myFilesMap = new HashMap(50);
    private String myOldString;
    private String myNewString;

    SearchResultCollectorReplacer(String oldString, String newString) {
        this.myOldString = oldString;
        this.myNewString = newString;
    }

    public IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public void aboutToStart() throws CoreException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accept(IResourceProxy resourceProxy, String line, int start, int length, int lineNumber) throws CoreException {
        IResource resource = resourceProxy.requestResource();
        if (!(resource instanceof IFile)) return;
        if (this.myFilesMap.containsKey(resource)) return;
        InputStream is = ((IFile)resource).getContents();
        BufferedReader reader = null;
        try {
            try {
                int size = (int)((IFile)resource).getFullPath().toFile().length();
                reader = new BufferedReader(new InputStreamReader(is));
                StringBuffer contents = new StringBuffer(size + size / 5);
                while (true) {
                    String lineStr;
                    if ((lineStr = reader.readLine()) == null) {
                        this.myFilesMap.put(resource, contents);
                        break;
                    }
                    contents.append(lineStr).append(System.getProperty("line.separator"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var13_14 = null;
                SafeIO.safeClose(reader, is);
                return;
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            SafeIO.safeClose(reader, is);
            throw throwable;
        }
        SafeIO.safeClose(reader, is);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void done() {
        StringBufferInputStream curStream = null;
        Iterator files = this.myFilesMap.keySet().iterator();
        while (files.hasNext()) {
            Object var9_8;
            IFile file = (IFile)files.next();
            StringBuffer oldContents = (StringBuffer)this.myFilesMap.get(file);
            String newContents = SearchResultCollectorReplacer.replace(oldContents.toString(), this.myOldString, this.myNewString);
            StringBuffer buffer = new StringBuffer(newContents);
            curStream = new StringBufferInputStream(newContents);
            try {
                try {
                    file.setContents((InputStream)curStream, true, true, null);
                }
                catch (CoreException cantSetContents) {
                    cantSetContents.printStackTrace();
                    var9_8 = null;
                    SafeIO.safeClose(null, curStream);
                    continue;
                }
                var9_8 = null;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                SafeIO.safeClose(null, curStream);
                throw throwable;
            }
            SafeIO.safeClose(null, curStream);
        }
        return;
    }

    private static String replace(String contents, String oldName, String newName) {
        StringBuffer result = new StringBuffer(contents.length() * 2);
        int lastIndex = 0;
        int nextIndex = contents.indexOf(oldName, lastIndex);
        int length = contents.length();
        while (nextIndex != -1) {
            result.append(contents.substring(lastIndex, nextIndex));
            if (SearchResultCollectorReplacer.isInsideOtherIdentifier(contents, length, nextIndex, oldName)) {
                result.append(oldName);
            } else {
                result.append(newName);
            }
            lastIndex = nextIndex + oldName.length();
            if (lastIndex >= length) {
                return result.toString();
            }
            nextIndex = contents.indexOf(oldName, lastIndex);
        }
        result.append(contents.substring(lastIndex));
        return result.toString();
    }

    private static boolean isValidFollowingChar(String text, int textLength, int occurencePos, String occurence) {
        if (occurencePos + occurence.length() >= textLength) {
            return true;
        }
        char followsChar = text.charAt(occurencePos + occurence.length());
        return !Character.isJavaIdentifierPart(followsChar);
    }

    private static boolean isValidPrecedingChar(String text, int textLength, int occurencePos, String occurence) {
        if (occurencePos == 0) {
            return true;
        }
        char precedingChar = text.charAt(occurencePos - 1);
        return !Character.isJavaIdentifierPart(precedingChar) && precedingChar != '.';
    }

    private static boolean isInsideOtherIdentifier(String text, int textLength, int occurencePos, String occurence) {
        Assert.isLegal((boolean)text.substring(occurencePos).startsWith(occurence));
        return !SearchResultCollectorReplacer.isValidFollowingChar(text, textLength, occurencePos, occurence) || !SearchResultCollectorReplacer.isValidPrecedingChar(text, textLength, occurencePos, occurence);
    }
}

