/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor.comments;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.refactor.comments.SearchResultCollectorReplacer;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.RenameHandler;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.UndoTransparableCommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.TextSearchEngine;

public class RenameJavaCommentsHandler
implements RenameHandler,
ModelAware {
    private UniqueName myModelUin;
    private IProject myProject;

    public void registered(Model model) {
        this.myModelUin = model.getUniqueName();
    }

    public void unregistered(Model model) {
        if (model.getUniqueName().equals(this.myModelUin)) {
            this.myModelUin = null;
        } else {
            System.err.println("ATTENTION: RenameTargetClassHandler: registered for : " + this.myModelUin + "\n unregistered for : " + model.getUniqueName());
        }
    }

    public void handleRename(UniqueName originalUniqueName, UniqueName newUniqueName) {
        if (originalUniqueName == null || newUniqueName == null || originalUniqueName.equals(newUniqueName)) {
            return;
        }
        Model model = ModelAccess.getModel((UniqueName)this.myModelUin);
        if (model == null || model.isDeleted()) {
            System.err.println("Model is not accessible: " + this.myModelUin);
            return;
        }
        final IProject project = this.getProject();
        if (project == null) {
            return;
        }
        Element newElement = model.findElement(newUniqueName);
        if (newElement == null || newElement.isDeleted()) {
            return;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(newElement);
        if (javaElement instanceof IType) {
            final String newQualifiedName = NameUtil.getTypeQualifiedName((IType)javaElement);
            final String oldQuailfiedName = NameUtil.getTypeQualifiedName(originalUniqueName);
            if (newQualifiedName == null || oldQuailfiedName == null) {
                return;
            }
            if (oldQuailfiedName.indexOf(".") < 0) {
                return;
            }
            ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

                public void run() {
                    RenameJavaCommentsHandler.refactorComments(oldQuailfiedName, newQualifiedName, project);
                }
            });
        }
    }

    private static String replace(String contents, String oldName, String newName) {
        int index = contents.indexOf(oldName, 0);
        while (index >= 0) {
            contents = contents.substring(0, index) + newName + contents.substring(index + oldName.length());
            index = contents.indexOf(oldName, index + newName.length());
        }
        return contents;
    }

    private static void refactorComments(String oldQualifiedName, String newQualifiedName, final IProject project) {
        new TextSearchEngine().search(ResourcesPlugin.getWorkspace(), oldQualifiedName, "", new ISearchScope(){

            public boolean encloses(IResourceProxy element) {
                return "java".equals(element.requestResource().getFileExtension()) && project.equals((Object)element.requestResource().getProject());
            }

            public String getDescription() {
                return "";
            }
        }, (ITextSearchResultCollector)new SearchResultCollectorReplacer(oldQualifiedName, newQualifiedName));
    }

    private IProject getProject() {
        if (this.myProject == null) {
            this.myProject = ModelUinSupport.getProject((UniqueName)this.myModelUin);
        }
        return this.myProject != null && this.myProject.isAccessible() ? this.myProject : null;
    }
}

