/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor;

import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.refactor.AbstractJavaReferenceFinder;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

public class TypeReferenceFinder
extends AbstractJavaReferenceFinder {
    public TypeReferenceFinder(IType typeToFind) {
        super((IJavaElement)typeToFind);
        this.setSearchLimit(3);
        this.setSearchScope(this.getDefaultSearchScope());
    }

    public void replaceBy(IType newType) {
        String newFullTypeName = TypeReferenceFinder.toFullSourceName(newType);
        String newShortTypeName = TypeReferenceFinder.toShortSourceName(newType);
        super.replaceBy(newFullTypeName, newShortTypeName);
    }

    private static String toFullSourceName(IType type) {
        String packageName = type.getPackageFragment().getElementName();
        String fullTypeName = type.getElementName();
        IJavaElement curParent = type.getParent();
        while (curParent instanceof IType) {
            fullTypeName = curParent.getElementName() + '.' + fullTypeName;
            curParent = curParent.getParent();
        }
        return "".equals(packageName) ? fullTypeName : packageName + '.' + fullTypeName;
    }

    private static String toShortSourceName(IType type) {
        String typeName = type.getElementName();
        return NameUtil.normalizeName(typeName);
    }
}

