/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdatingRefactoring;
import org.eclipse.swt.widgets.Display;

public class RenameRefactoringFactory {
    public static IRenameRefactoring getRenameRefactoring(IJavaElement javaElement) {
        if (Display.getCurrent() == null) {
            return null;
        }
        if (javaElement == null) {
            return null;
        }
        String elementName = javaElement.getElementName();
        RenamePackageRefactoring result = null;
        switch (javaElement.getElementType()) {
            case 5: {
                if (RenameRefactoringFactory.isPrefixWithNumberNoCase(elementName, "Class") || RenameRefactoringFactory.isPrefixWithNumberNoCase(elementName, "Interface")) {
                    return null;
                }
                result = new RenameCompilationUnitRefactoring((ICompilationUnit)javaElement);
                break;
            }
            case 4: {
                result = new RenamePackageRefactoring((IPackageFragment)javaElement);
                break;
            }
            case 7: {
                if (RenameRefactoringFactory.isPrefixWithNumberNoCase(elementName, "Class") || RenameRefactoringFactory.isPrefixWithNumberNoCase(elementName, "Interface")) {
                    return null;
                }
                result = new RenameTypeRefactoring((IType)javaElement);
                break;
            }
            case 9: {
                if (RenameRefactoringFactory.isPrefixWithNumberNoCase(elementName, "Operation")) {
                    return null;
                }
                IMethod method = (IMethod)javaElement;
                result = RenameRefactoringFactory.getRenameMethodRefactoring(method);
                break;
            }
            case 8: {
                if (RenameRefactoringFactory.isPrefixWithNumberNoCase(elementName, "Attribute")) {
                    return null;
                }
                result = new RenameFieldRefactoring((IField)javaElement);
                break;
            }
        }
        if (result instanceof ITextUpdatingRefactoring) {
            ((ITextUpdatingRefactoring)result).setUpdateJavaDoc(RenameRefactoringFactory.shouldUpdateJavaDoc());
            ((ITextUpdatingRefactoring)result).setUpdateComments(RenameRefactoringFactory.shouldUpdateComments());
            ((ITextUpdatingRefactoring)result).setUpdateStrings(RenameRefactoringFactory.shouldUpdateStrings());
        }
        return result;
    }

    private static RenameMethodRefactoring getRenameMethodRefactoring(IMethod method) {
        try {
            return RenameMethodRefactoring.createInstance((IMethod)method);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    private static String[] getCodeConventionPrefixes() {
        return new String[0];
    }

    private static String[] getCodeConventionSuffixes() {
        return new String[0];
    }

    private static boolean shouldUpdateJavaDoc() {
        return true;
    }

    private static boolean shouldUpdateStrings() {
        return true;
    }

    private static boolean shouldUpdateComments() {
        return true;
    }

    private static boolean isPrefixWithNumberNoCase(String testedValue, String prefix) {
        JavaProviderPlugin.getDefault();
        if (JavaProviderPlugin.isRefactorDefaultNames()) {
            return false;
        }
        if (testedValue == null || prefix == null) {
            return false;
        }
        if (testedValue.toLowerCase().startsWith(prefix.toLowerCase())) {
            try {
                return Integer.valueOf(testedValue.substring(prefix.length())) != null;
            }
            catch (NumberFormatException badNumber) {
                return false;
            }
        }
        return false;
    }
}

