/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IChangeExceptionHandler;
import org.eclipse.jdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.changes.AbortChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.refactoring.changes.ChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RefactorPerformer {
    public static boolean perform(IRenameRefactoring refactoring, String newName, boolean warningsAllowed) {
        try {
            if (!RefactorPerformer.canPerformFull(refactoring, newName, warningsAllowed)) {
                return false;
            }
            refactoring.setNewName(newName);
            IChange change = refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            PerformChangeOperation changeOperation = new PerformChangeOperation(change);
            RefactorPerformer.performRefactoring(changeOperation, refactoring);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean canPerformNaive(IRenameRefactoring refactoring, String newName, boolean warningsAllowed) {
        if (!(refactoring instanceof Refactoring)) {
            return false;
        }
        try {
            RefactoringStatus checkNewName = refactoring.checkNewName(newName);
            if (!RefactorPerformer.checkStatus(checkNewName, warningsAllowed)) {
                return false;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean canPerformFull(IRenameRefactoring refactoring, String newName, boolean warningsAllowed) {
        if (!RefactorPerformer.canPerformNaive(refactoring, newName, warningsAllowed)) {
            return false;
        }
        try {
            refactoring.setNewName(newName);
            RefactoringStatus checkPreconditions = refactoring.checkPreconditions((IProgressMonitor)new NullProgressMonitor());
            if (!RefactorPerformer.checkStatus(checkPreconditions, warningsAllowed)) {
                return false;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean checkStatus(RefactoringStatus status, boolean warningsAllowed) {
        int allowedLevel = warningsAllowed ? 2 : 0;
        return status.getSeverity() <= allowedLevel;
    }

    private static boolean performRefactoring(PerformChangeOperation op, IRenameRefactoring refactoring) {
        ChangeContext context = new ChangeContext((IChangeExceptionHandler)new ChangeExceptionHandler(Display.getDefault().getActiveShell()));
        boolean success = false;
        IUndoManager undoManager = Refactoring.getUndoManager();
        try {
            block7: {
                try {
                    op.setChangeContext(context);
                    undoManager.aboutToPerformRefactoring();
                    op.run((IProgressMonitor)new NullProgressMonitor());
                    if (!op.changeExecuted()) break block7;
                    if (!op.getChange().isUndoable()) {
                        success = false;
                        break block7;
                    }
                    undoManager.addUndo(refactoring.getName(), op.getChange().getUndoChange());
                    success = true;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof ChangeAbortException) {
                        success = RefactorPerformer.handleChangeAbortException(context, (ChangeAbortException)t);
                        boolean bl = true;
                        Object var9_6 = null;
                        context.clearPerformedChanges();
                        undoManager.refactoringPerformed(success);
                        return bl;
                    }
                    RefactorPerformer.handleUnexpectedException(e);
                    boolean bl = false;
                    Object var9_7 = null;
                    context.clearPerformedChanges();
                    undoManager.refactoringPerformed(success);
                    return bl;
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    Object var9_8 = null;
                    context.clearPerformedChanges();
                    undoManager.refactoringPerformed(success);
                    return bl;
                }
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            context.clearPerformedChanges();
            undoManager.refactoringPerformed(success);
            throw throwable;
        }
        context.clearPerformedChanges();
        undoManager.refactoringPerformed(success);
        return true;
    }

    private static boolean handleChangeAbortException(final ChangeContext context, ChangeAbortException exception) {
        if (!context.getTryToUndo()) {
            return false;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor pm) throws CoreException, InvocationTargetException {
                ChangeContext undoContext = new ChangeContext((IChangeExceptionHandler)new AbortChangeExceptionHandler());
                try {
                    try {
                        IChange[] changes = context.getPerformedChanges();
                        pm.beginTask(RefactoringMessages.getString((String)"RefactoringWizard.undoing"), changes.length);
                        NullProgressMonitor sub = new NullProgressMonitor();
                        int i = changes.length - 1;
                        while (i >= 0) {
                            IChange change = changes[i];
                            pm.subTask(change.getName());
                            change.getUndoChange().perform(undoContext, (IProgressMonitor)sub);
                            pm.worked(1);
                            --i;
                        }
                    }
                    catch (ChangeAbortException e) {
                        throw new InvocationTargetException(e.getThrowable());
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
            }
        };
        try {
            new ProgressMonitorDialog(JavaPlugin.getActiveWorkbenchShell()).run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            RefactorPerformer.handleUnexpectedException(e);
            return false;
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return true;
    }

    private static void handleUnexpectedException(InvocationTargetException e) {
        ExceptionHandler.handle((InvocationTargetException)e, (String)"RefactoringWizard.refactoring", (String)"RefactoringWizard.unexpected_exception_1");
    }
}

