/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.refactor.ExFileContentsReplacer;
import com.tssap.selena.internal.core.providers.java.refactor.JavaOccurenceInfo;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;

public class FileOccurences {
    private SortedSet myOccurences;
    private IFile myResource;
    private long myOriginalStamp;

    public FileOccurences(IFile resource) {
        this.myResource = resource;
        this.myOriginalStamp = resource.getModificationStamp();
    }

    public void addOccurence(int start, int end, IJavaElement enclosingElement) {
        if (this.myOccurences == null) {
            this.myOccurences = new TreeSet();
        }
        this.myOccurences.add(new JavaOccurenceInfo(start, end, enclosingElement));
    }

    public boolean canReplace() {
        return this.myResource.exists() && !this.myResource.isReadOnly() && this.checkConsistency() && this.myResource.getModificationStamp() == this.myOriginalStamp;
    }

    public void replace(String lReplace, String sReplace) {
        if (this.myOccurences == null) {
            return;
        }
        try {
            ExFileContentsReplacer.processFile(this.myResource, this.myOccurences, lReplace, sReplace);
        }
        catch (CoreException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    private boolean checkConsistency() {
        int nextAllowedStart = -1;
        Iterator it = this.myOccurences.iterator();
        while (it.hasNext()) {
            JavaOccurenceInfo next = (JavaOccurenceInfo)it.next();
            if (next.getStart() <= nextAllowedStart) {
                return false;
            }
            nextAllowedStart = next.getEnd();
        }
        return true;
    }
}

