/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NullMonitor;
import com.tssap.selena.model.util.text.FileContentsReplacer;
import com.tssap.selena.model.util.text.IOCloser;
import com.tssap.selena.model.util.text.IOccurenceInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;

public class ExFileContentsReplacer
extends FileContentsReplacer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getReplacedContents(IFile file, SortedSet occurences, String lReplace, String sReplace) throws CoreException {
        String string;
        InputStream stream = file.getContents();
        InputStreamReader in = null;
        StringBuffer result = new StringBuffer();
        try {
            try {
                in = new InputStreamReader((InputStream)new BufferedInputStream(stream), ResourcesPlugin.getEncoding());
                int curOffset = 0;
                Iterator infos = occurences.iterator();
                while (true) {
                    if (!infos.hasNext()) {
                        result.append(FileContentsReplacer.copyAllRemaining((InputStreamReader)in));
                        string = result.toString();
                        Object var13_13 = null;
                        break;
                    }
                    IOccurenceInfo curInfo = (IOccurenceInfo)infos.next();
                    int nextOffset = curInfo.getStart();
                    String s = FileContentsReplacer.copyUntilNextOccurence((InputStreamReader)in, (int)(nextOffset - curOffset));
                    result.append(s);
                    s = FileContentsReplacer.copyUntilNextOccurence((InputStreamReader)in, (int)curInfo.getLength());
                    if (sReplace == null) {
                        result.append(lReplace);
                    } else if (s.equals(sReplace)) {
                        result.append(s);
                    } else if (s.indexOf(".") == -1 && JavaProviderPlugin.isImportOptimizationEnabled()) {
                        result.append(sReplace);
                    } else {
                        result.append(lReplace);
                    }
                    curOffset = nextOffset + curInfo.getLength();
                }
            }
            catch (IOException badIO) {
                throw FileContentsReplacer.newCoreException((Exception)badIO);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            IOCloser.perform(in, (InputStream)stream);
            throw throwable;
        }
        IOCloser.perform((Reader)in, (InputStream)stream);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processFile(IFile file, SortedSet occurences, String lReplace, String sReplace) throws CoreException {
        String replacedContents = ExFileContentsReplacer.getReplacedContents(file, occurences, lReplace, sReplace);
        ByteArrayInputStream replacedStream = null;
        try {
            try {
                replacedStream = new ByteArrayInputStream(replacedContents.getBytes(ResourcesPlugin.getEncoding()));
                file.setContents((InputStream)replacedStream, true, true, NullMonitor.getSharedInstance());
            }
            catch (UnsupportedEncodingException badEncoding) {
                badEncoding.printStackTrace();
                throw FileContentsReplacer.newCoreException((Exception)badEncoding);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            IOCloser.perform(null, (InputStream)replacedStream);
            if (!JavaProviderPlugin.isImportOptimizationEnabled()) throw throwable;
            IJavaElement javaElement222 = JavaCore.create((IFile)file);
            if (!(javaElement222 instanceof ICompilationUnit)) throw throwable;
            if (!javaElement222.exists()) throw throwable;
            ICompilationUnit compilationUnit = (ICompilationUnit)javaElement222;
            if (sReplace == null) throw throwable;
            compilationUnit.createImport(lReplace, null, NullMonitor.getSharedInstance());
            throw throwable;
        }
        IOCloser.perform(null, (InputStream)replacedStream);
        if (!JavaProviderPlugin.isImportOptimizationEnabled()) return;
        IJavaElement javaElement222 = JavaCore.create((IFile)file);
        if (!(javaElement222 instanceof ICompilationUnit)) return;
        if (!javaElement222.exists()) return;
        ICompilationUnit compilationUnit = (ICompilationUnit)javaElement222;
        if (sReplace == null) return;
        compilationUnit.createImport(lReplace, null, NullMonitor.getSharedInstance());
    }
}

