/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.refactor;

import com.tssap.selena.internal.core.providers.java.refactor.FileOccurences;
import com.tssap.selena.internal.core.providers.java.refactor.SameProjectSearchScope;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;

public abstract class AbstractJavaReferenceFinder
implements IJavaSearchResultCollector {
    protected static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    protected static final int DEFAULT_SEARCH_LIMIT = 3;
    private IJavaElement myElementToFind;
    private IJavaSearchScope mySearchScope;
    private int mySearchLimit;
    private HashMap myFullPath2Infos;
    private boolean mySearchSuccessful;

    public AbstractJavaReferenceFinder(IJavaElement elementToFind) {
        this.myElementToFind = elementToFind;
        this.mySearchSuccessful = false;
        this.setSearchLimit(3);
    }

    public void removePathFromResults(IPath fullPath) {
        if (this.myFullPath2Infos != null && fullPath != null) {
            this.myFullPath2Infos.remove(fullPath);
        }
    }

    protected void setSearchScope(IJavaSearchScope scope) {
        this.mySearchScope = scope;
    }

    protected IJavaSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    protected void setSearchLimit(int javaSearchConstant) {
        this.mySearchLimit = javaSearchConstant;
    }

    protected IJavaSearchScope getDefaultSearchScope() {
        return new SameProjectSearchScope(this.myElementToFind.getJavaProject());
    }

    public final void find() {
        try {
            this.mySearchSuccessful = false;
            this.myFullPath2Infos = null;
            if (this.mySearchScope == null) {
                this.mySearchScope = this.getDefaultSearchScope();
            }
            new SearchEngine().search(ResourcesPlugin.getWorkspace(), this.myElementToFind, this.mySearchLimit, this.mySearchScope, (IJavaSearchResultCollector)this);
        }
        catch (JavaModelException e) {
            this.mySearchSuccessful = false;
            e.printStackTrace();
        }
    }

    protected final void replaceBy(String replaceBy, String shortReplaceBy) {
        if (!this.mySearchSuccessful || replaceBy == null) {
            return;
        }
        Iterator entries = this.myFullPath2Infos.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            FileOccurences curInfo = (FileOccurences)curEntry.getValue();
            if (!curInfo.canReplace()) continue;
            curInfo.replace(replaceBy, shortReplaceBy);
        }
    }

    public final IProgressMonitor getProgressMonitor() {
        return NULL_MONITOR;
    }

    public final void aboutToStart() {
        this.myFullPath2Infos = new HashMap(20);
    }

    public final void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
        if (accuracy != 0 || start == -1 || end == -1) {
            return;
        }
        Assert.isLegal((resource.getType() == 1 ? 1 : 0) != 0);
        IPath fullPath = resource.getFullPath();
        FileOccurences pathInfo = (FileOccurences)this.myFullPath2Infos.get(fullPath);
        if (pathInfo == null) {
            pathInfo = new FileOccurences((IFile)resource);
            this.myFullPath2Infos.put(fullPath, pathInfo);
        }
        pathInfo.addOccurence(start, end, enclosingElement);
    }

    public final void done() {
        this.mySearchSuccessful = true;
    }
}

