/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.FieldUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class TypePropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$type", "$array", "$typeReferencedElement"};

    public String getPropertyValue(Element element, String propertyName) {
        try {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement instanceof IField) {
                if ("$type".equals(propertyName)) {
                    String typeSignature = ((IField)javaElement).getTypeSignature();
                    return Signature.toString((String)typeSignature);
                }
                if ("$typeReferencedElement".equals(propertyName)) {
                    IField field = (IField)javaElement;
                    String refType = JDTUtil.getRefType(field);
                    return TypeNameResolver.resolveType(this.myModel, field.getDeclaringType(), refType, true);
                }
                return null;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!this.canChange(element)) {
            return false;
        }
        if (propertyValue == null) {
            return false;
        }
        if ("$type".equals(propertyName)) {
            return TypeNameUtil.isPrimitiveType(propertyValue) || TypeNameUtil.isNonPrimitiveType(propertyValue);
        }
        UniqueName uniqueName = ModelAccess.createUniqueName((String)propertyValue);
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName);
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            try {
                int flags = type.getFlags();
                return !Flags.isPrivate((int)flags);
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            MySetPropertyOperation propertyOperation = null;
            if ("$type".equals(propertyName)) {
                propertyOperation = new MyTypeSetPropertyOperation();
            } else if ("$typeReferencedElement".equals(propertyName)) {
                propertyOperation = new MyRefTypeSetPropertyOperation();
            }
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, true, propertyName, (Object)propertyValue, null, (PropertyOperation)propertyOperation);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isFieldUniqueName(uniqueName);
    }

    private abstract class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        protected String propertyOperation(IJavaElement javaElement, IDOMField domField, String typeName) {
            DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(TypePropertyProvider.this.myJavaProject, javaElement.getParent(), 3);
            IType type = ((IField)javaElement).getDeclaringType();
            typeName = NameUtil.normalizeName(typeName);
            if (ImportStatementSupport.isImportStatamentSupported()) {
                ImportStatementSupport.addImportStatament(TypePropertyProvider.this.myModel, javaElement, (IDOMNode)domField, typeName);
                typeName = NameUtil.getTypeShortName(type, typeName);
            }
            return FieldUtil.fixupFieldInitializer((IJavaElement)type, domField, typeName);
        }

        public abstract String propertyOperation(IJavaElement var1, IDOMNode var2, String var3, Object var4, Object var5);
    }

    private class MyRefTypeSetPropertyOperation
    extends MySetPropertyOperation {
        private MyRefTypeSetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMField) {
                UniqueName uniqueName = ModelAccess.createUniqueName((String)((String)newPropertyValue));
                IJavaElement refJavaElement = ElementUtil.getJavaElement(TypePropertyProvider.this.myModelUniqueName, uniqueName);
                if (refJavaElement instanceof IType) {
                    IType type = (IType)refJavaElement;
                    String typeName = type.getFullyQualifiedName();
                    return this.propertyOperation(javaElement, (IDOMField)domNode, typeName);
                }
            }
            return null;
        }
    }

    private class MyTypeSetPropertyOperation
    extends MySetPropertyOperation {
        private MyTypeSetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMField) {
                return this.propertyOperation(javaElement, (IDOMField)domNode, (String)newPropertyValue);
            }
            return null;
        }
    }
}

