/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.ListPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class ThrowsListPropertyProvider
extends ListPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$throws"};

    public PropertyEnumeration properties(Element element) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        String[] propertyValues = this.getPropertyValues(javaElement);
        ArrayList<MyPropertyImpl> properties = new ArrayList<MyPropertyImpl>();
        int i = 0;
        while (i < propertyValues.length) {
            properties.add(new MyPropertyImpl(javaElement, element, propertyValues[i]));
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(((AbstractList)properties).iterator());
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return this.canModifyPropertyValue(element, propertyValue, true);
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        try {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement != null && PropertyOperationUtil.doPropertyOperation(this.myJavaProject, javaElement, true, propertyName, (Object)propertyValue, null, (PropertyOperation)new MyAddPropertyOperation())) {
                return new MyPropertyImpl(javaElement, element, propertyValue);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return this.canModifyPropertyValue(element, propertyValue, false);
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, true, propertyName, (Object)propertyValue, null, (PropertyOperation)new MySetPropertyOperation());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    private boolean canModifyPropertyValue(Element element, String propertyValue, boolean add) {
        if (!this.canChange(element)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (!(javaElement instanceof IMethod)) {
            return false;
        }
        if (propertyValue == null) {
            return true;
        }
        IType type = ((IMethod)javaElement).getDeclaringType();
        String[] typeNames = this.getPropertyValues((IJavaElement)type);
        String newTypeName = propertyValue;
        return ListPropertyProvider.validateTypeName(this.myModel, type, typeNames, newTypeName, add, ListPropertyProvider.K_EXCEPTION);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isMethodUniqueName(uniqueName);
    }

    protected String[] getPropertyValues(IJavaElement javaElement) {
        try {
            if (javaElement instanceof IMethod) {
                ArrayList<String> exceptionsList = new ArrayList<String>();
                IMethod method = (IMethod)javaElement;
                String[] exceptions = method.getExceptionTypes();
                int i = 0;
                while (i < exceptions.length) {
                    String refType = Signature.toString((String)exceptions[i]);
                    exceptionsList.add(refType);
                    ++i;
                }
                return exceptionsList.toArray(new String[exceptionsList.size()]);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return new String[0];
    }

    private String doPropertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object propertyValue, boolean add) {
        if (!(domNode instanceof IDOMMethod)) {
            return null;
        }
        IDOMMethod domMethod = (IDOMMethod)domNode;
        if (propertyValue == null) {
            if (add) {
                return null;
            }
            domMethod.setExceptions(new String[0]);
            return domMethod.getContents();
        }
        IType type = ((IMethod)javaElement).getDeclaringType();
        StringTokenizer st = new StringTokenizer((String)propertyValue, ",");
        String[] newExceptions = new String[st.countTokens()];
        int i = 0;
        while (i < newExceptions.length) {
            String typeName = st.nextToken().trim();
            typeName = NameUtil.normalizeName(typeName);
            if (ImportStatementSupport.isImportStatamentSupported() && ImportStatementSupport.addImportStatament(this.myModel, javaElement, domNode, typeName)) {
                typeName = NameUtil.getTypeShortName(type, typeName);
            }
            newExceptions[i] = typeName;
            ++i;
        }
        if (add) {
            String[] exceptions = domMethod.getExceptions();
            newExceptions = ArrayUtil.merge(exceptions, newExceptions);
        }
        domMethod.setExceptions(newExceptions);
        return domMethod.getContents();
    }

    private class MyPropertyImpl
    extends ListPropertyProvider.PropertyImpl {
        public MyPropertyImpl(IJavaElement javaElement, Element element, String propertyValue) {
            super(javaElement, element, "$throws", propertyValue);
        }

        protected PropertyOperation getPropertyOperation() {
            return new PropertyOperation(){

                public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
                    if (!(domNode instanceof IDOMMethod)) {
                        return null;
                    }
                    IDOMMethod domMethod = (IDOMMethod)domNode;
                    IType type = ((IMethod)javaElement).getDeclaringType();
                    String[] exceptions = domMethod.getExceptions();
                    int i = 0;
                    while (i < exceptions.length) {
                        if (((String)oldPropertyValue).endsWith(exceptions[i])) {
                            if (newPropertyValue != null) {
                                String typeName = (String)newPropertyValue;
                                typeName = NameUtil.normalizeName(typeName);
                                if (ImportStatementSupport.isImportStatamentSupported() && ImportStatementSupport.addImportStatament(ThrowsListPropertyProvider.this.myModel, javaElement, domNode, typeName)) {
                                    typeName = NameUtil.getTypeShortName(type, typeName);
                                }
                                exceptions[i] = typeName;
                            } else {
                                exceptions = ArrayUtil.remove(exceptions, i);
                            }
                            domMethod.setExceptions(exceptions);
                            return domMethod.getContents();
                        }
                        ++i;
                    }
                    return null;
                }
            };
        }
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            return ThrowsListPropertyProvider.this.doPropertyOperation(javaElement, domNode, propertyName, newPropertyValue, false);
        }
    }

    private class MyAddPropertyOperation
    implements PropertyOperation {
        private MyAddPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            return ThrowsListPropertyProvider.this.doPropertyOperation(javaElement, domNode, propertyName, newPropertyValue, true);
        }
    }
}

