/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkParserCache;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.internal.core.providers.java.designlinks.IExSourceReference;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TextPositionPropertyProvider
extends AbstractGetPropertyProvider {
    private static final boolean ECLIPSE_STYLE_POSITIONS = true;
    private static final String[] PROPERTY_NAMES = new String[]{"$startPosition", "$endPosition"};

    public String getPropertyValue(Element element, String propertyName) {
        try {
            IJavaElement javaElement;
            UniqueName uniqueName = element.getUniqueName();
            if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
                if (NameUtil.isAssociationUniqueName(uniqueName)) {
                    uniqueName = NameUtil.getFUINFromAUIN(uniqueName);
                } else if (NameUtil.isGeneralizationUniqueName(uniqueName)) {
                    uniqueName = NameUtil.getTUINFromGUIN(uniqueName);
                } else if (NameUtil.isImplementationUniqueName(uniqueName)) {
                    uniqueName = NameUtil.getTUINFromIUIN(uniqueName);
                } else if (NameUtil.isDependencyUniqueName(uniqueName)) {
                    IDependencyLink dependencyLink = this.getDependencyLink(element);
                    ISourceReference sourceReference = dependencyLink.getSourceReference();
                    ISourceRange sourceRange = ((IExSourceReference)sourceReference).getFileSourceRange();
                    return this.getValue(sourceRange, propertyName);
                }
            }
            if ((javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName)) instanceof IMember) {
                ISourceRange sourceRange = TextPositionPropertyProvider.getSourceRange((IMember)javaElement);
                return this.getValue(sourceRange, propertyName);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private String getValue(ISourceRange sourceRange, String propertyName) {
        if (sourceRange == null) {
            return null;
        }
        if ("$startPosition".equals(propertyName)) {
            int startIndex = sourceRange.getOffset();
            return startIndex < 0 ? null : Integer.toString(startIndex);
        }
        int endIndex = sourceRange.getOffset() + sourceRange.getLength() - 1;
        return endIndex < 0 ? null : Integer.toString(endIndex);
    }

    private IDependencyLink getDependencyLink(Element link) {
        Entity modelType = link.getParent();
        if (modelType == null) {
            return null;
        }
        String linkName = NameUtil.getFNFromDUIN(link.getUniqueName());
        if (linkName == null) {
            return null;
        }
        IJavaElement parentType = ElementUtil.getJavaElement((Element)modelType);
        if (parentType instanceof IType) {
            IDependencyLinkParser linkParser = DependencyLinkParserCache.get(this.myJavaProject, (IType)parentType);
            if (linkParser == null) {
                return null;
            }
            return linkParser.getDependencyLink(linkName);
        }
        return null;
    }

    protected static ISourceRange getSourceRange(IMember member) throws JavaModelException {
        return member.getNameRange();
    }
}

