/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.JavaCommentsParsersCache;
import com.tssap.selena.internal.core.providers.java.property.SetPropertyImpl;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;

public class TagPropertyProvider
extends AbstractSetPropertyProvider {
    private static final String LEFT = "<{";
    private static final String RIGHT = "}>";
    private static final String[] PROPERTY_NAMES = new String[]{"$comment"};

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return propertyName == null || propertyName.charAt(0) == '@' || "$comment".equals(propertyName) || "$description".equals(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        IJavaComment javaComments = JavaCommentsParsersCache.get(element);
        if (javaComments == null) {
            return null;
        }
        if ("$comment".equals(propertyName) || "$description".equals(propertyName)) {
            return javaComments.getComment();
        }
        Enumeration tags = this.getCompactTagsExpanded(javaComments, propertyName);
        if (tags.hasMoreElements()) {
            ITag tag = (ITag)tags.nextElement();
            if ("@associates".equals(tag.getName())) {
                return TagPropertyProvider.fromDUIN(tag.getValue());
            }
            return tag.getValue();
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        if (!this.canChange(element)) {
            return false;
        }
        if (propertyValue == null) {
            return false;
        }
        if ("$comment".equals(propertyName) || "$description".equals(propertyName)) {
            return false;
        }
        IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(element);
        return javaElement instanceof IMember;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(element);
        IJavaComment javaComments = JavaCommentsParsersCache.get(element);
        ITag tag = javaComments.addTag(propertyName, propertyValue);
        javaComments.synchronize(true);
        return this.createProperty(JavaCommentsParsersCache.getCorrespondingElement(element), javaComments, tag);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!this.canChange(element)) {
            return false;
        }
        IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(element);
        return javaElement instanceof IMember;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(element);
        IJavaComment javaComments = JavaCommentsParsersCache.get(element);
        if ("$comment".equals(propertyName) || "$description".equals(propertyName)) {
            javaComments.setComment(propertyValue);
        } else {
            Enumeration enumeration;
            if ("@associates".equals(propertyName)) {
                propertyValue = TagPropertyProvider.toDUIN(propertyValue);
            }
            if ((enumeration = javaComments.getTags(propertyName)).hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    ITag tag = (ITag)enumeration.nextElement();
                    if (propertyValue != null) {
                        if ("@link".equals(propertyName)) {
                            TagPropertyProvider.setCompositeLinkTypeValue(tag, propertyValue);
                        } else {
                            tag.setValue(propertyValue);
                        }
                        break;
                    }
                    tag.setValue(propertyValue);
                }
            } else if (!this.processIfCompositeAssociates(javaComments, propertyName, propertyValue) && propertyValue != null) {
                javaComments.addTag(propertyName, propertyValue);
            }
        }
        javaComments.synchronize(true);
    }

    public PropertyEnumeration properties(Element element) {
        MyCommentSetPropertyImpl property;
        IJavaComment javaComments = JavaCommentsParsersCache.get(element);
        if (javaComments == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        ArrayList<MyCommentSetPropertyImpl> properties = new ArrayList<MyCommentSetPropertyImpl>();
        if (javaComments.getComment() != null) {
            property = new MyCommentSetPropertyImpl(element, javaComments);
            properties.add(property);
        }
        Enumeration tags = this.expandCompactTags(javaComments);
        while (tags.hasMoreElements()) {
            ITag tag = (ITag)tags.nextElement();
            property = this.createProperty(element, javaComments, tag);
            properties.add(property);
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        if (propertyName == null) {
            return this.properties(element);
        }
        IJavaComment javaComments = JavaCommentsParsersCache.get(element);
        if (javaComments == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        Enumeration en = this.getCompactTagsExpanded(javaComments, propertyName);
        if (!en.hasMoreElements()) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        ArrayList<Property> rv = new ArrayList<Property>(3);
        do {
            ITag next = (ITag)en.nextElement();
            rv.add(this.createProperty(element, javaComments, next));
        } while (en.hasMoreElements());
        return EnumerationConverter.toPropertyEnumeration(rv.iterator());
    }

    private TagPropertyProvider getItself() {
        return this;
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    protected boolean canChange(Element element) {
        IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(element);
        if (javaElement == null) {
            return false;
        }
        return ElementUtil.isWritableElement(javaElement);
    }

    private boolean processIfCompositeAssociates(IJavaComment javaComments, String propertyName, String propertyValue) {
        ITag linkTypeTag;
        if ("@associates".equals(propertyName) && (linkTypeTag = TagPropertyProvider.findCompositeLinkType(javaComments)) != null) {
            TagPropertyProvider.setCompositeLinkAssociates(linkTypeTag, propertyValue);
            return true;
        }
        return false;
    }

    private Property createProperty(Element element, IJavaComment javaComments, ITag tag) {
        return new MyTagSetPropertyImpl(element, javaComments, tag);
    }

    public static String toDUIN(String fullQualifiedName) {
        if (fullQualifiedName != null) {
            if (!fullQualifiedName.startsWith(LEFT)) {
                fullQualifiedName = LEFT + fullQualifiedName;
            }
            if (!fullQualifiedName.endsWith(RIGHT)) {
                fullQualifiedName = fullQualifiedName + RIGHT;
            }
        }
        return fullQualifiedName;
    }

    public static String fromDUIN(String dUIN) {
        if (dUIN != null && dUIN.length() > 4) {
            if ((dUIN = dUIN.trim()).startsWith(LEFT)) {
                dUIN = dUIN.substring(2);
            }
            if (dUIN.endsWith(RIGHT)) {
                dUIN = dUIN.substring(0, dUIN.length() - 2);
            }
            dUIN = dUIN.trim();
            return dUIN;
        }
        return null;
    }

    private static void setCompositeLinkTypeValue(ITag compositeLinkTag, String linkTypeValue) {
        TagPropertyProvider.replaceSpaceSeparatedValueElement(compositeLinkTag, 0, linkTypeValue);
    }

    private static String getCompositeLinkTypeValue(ITag compositeLinkTag) {
        return TagPropertyProvider.getSpaceSeparatedValueElement(compositeLinkTag, 0);
    }

    private static void setCompositeLinkAssociates(ITag compositeLinkTag, String associatesValue) {
        TagPropertyProvider.replaceSpaceSeparatedValueElement(compositeLinkTag, 1, associatesValue);
    }

    private static String getCompositeLinkAssociates(ITag compositeLinkTag) {
        return TagPropertyProvider.getSpaceSeparatedValueElement(compositeLinkTag, 1);
    }

    private static void replaceSpaceSeparatedValueElement(ITag tag, int elementIndex, String newValue) {
        List elements = TagPropertyProvider.getSpaceSeparatedValues(tag.getValue());
        if (elements.size() <= elementIndex) {
            if (newValue == null) {
                return;
            }
            elements.add(newValue);
        } else if (newValue == null) {
            elements.remove(elementIndex);
        } else {
            elements.set(elementIndex, newValue);
        }
        StringBuffer result = new StringBuffer();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            result.append((String)it.next());
            result.append(' ');
        }
        tag.setValue(result.toString());
    }

    private static String getSpaceSeparatedValueElement(ITag tag, int index) {
        List elements = TagPropertyProvider.getSpaceSeparatedValues(tag.getValue());
        if (index < elements.size()) {
            return (String)elements.get(index);
        }
        return "";
    }

    private static List getSpaceSeparatedValues(String value) {
        if (value == null) {
            value = "";
        }
        value.trim();
        ArrayList<String> elements = new ArrayList<String>();
        int space = value.indexOf(32);
        int prev = 0;
        while (prev < value.length()) {
            String candidate;
            if (space == -1) {
                space = value.length();
            }
            if ((candidate = value.substring(prev, space).trim()).length() > 0) {
                elements.add(candidate);
            }
            prev = space + 1;
            space = value.indexOf(32, prev + 1);
        }
        return elements;
    }

    private static ITag findCompositeLinkType(IJavaComment javaComments) {
        Enumeration en = javaComments.getTags("@link");
        if (en.hasMoreElements()) {
            return (ITag)en.nextElement();
        }
        return null;
    }

    private static boolean isComposite(ITag tag) {
        return TagPropertyProvider.getSpaceSeparatedValues(tag.getValue()).size() > 1;
    }

    private Enumeration expandCompactTags(IJavaComment javaComments) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!javaComments.hasTags("@link")) {
            return javaComments.getTags();
        }
        Enumeration en = javaComments.getTags();
        while (en.hasMoreElements()) {
            ITag next = (ITag)en.nextElement();
            if ("@link".equals(next.getName()) && TagPropertyProvider.isComposite(next)) {
                list.add(new FakeLinkTypeTag(next));
                list.add(new FakeAssociatesTag(next));
                continue;
            }
            list.add(next);
        }
        return Collections.enumeration(list);
    }

    private Enumeration getCompactTagsExpanded(IJavaComment javaComments, String propertyName) {
        Enumeration en = javaComments.getTags(propertyName);
        if (!en.hasMoreElements()) {
            if ("@associates".equals(propertyName) && javaComments.hasTags("@link")) {
                en = javaComments.getTags("@link");
                while (en.hasMoreElements()) {
                    ITag linkTag = (ITag)en.nextElement();
                    if (!TagPropertyProvider.isComposite(linkTag)) continue;
                    return Collections.enumeration(Collections.singletonList(new FakeAssociatesTag(linkTag)));
                }
            }
        } else if ("@link".equals(propertyName)) {
            ArrayList<ITag> rv = new ArrayList<ITag>(2);
            while (en.hasMoreElements()) {
                ITag next = (ITag)en.nextElement();
                if (TagPropertyProvider.isComposite(next)) {
                    rv.add(new FakeLinkTypeTag(next));
                    continue;
                }
                rv.add(next);
            }
            en = Collections.enumeration(rv);
        }
        return en;
    }

    private static class FakeAssociatesTag
    implements ITag {
        private final ITag myCompositeTag;

        private FakeAssociatesTag(ITag compositeTag) {
            this.myCompositeTag = compositeTag;
        }

        public String getName() {
            return "@associates";
        }

        public String getValue() {
            return TagPropertyProvider.getCompositeLinkAssociates(this.myCompositeTag);
        }

        public void setValue(String newValue) {
            TagPropertyProvider.setCompositeLinkAssociates(this.myCompositeTag, newValue);
        }
    }

    private static class FakeLinkTypeTag
    implements ITag {
        private final ITag myCompositeTag;

        private FakeLinkTypeTag(ITag compositeTag) {
            this.myCompositeTag = compositeTag;
        }

        public String getName() {
            return "@link";
        }

        public String getValue() {
            return TagPropertyProvider.getCompositeLinkTypeValue(this.myCompositeTag);
        }

        public void setValue(String newValue) {
            TagPropertyProvider.setCompositeLinkTypeValue(this.myCompositeTag, newValue);
        }
    }

    private class MyTagSetPropertyImpl
    extends SetPropertyImpl {
        private IJavaComment myJavaComments;
        private ITag myTag;

        public MyTagSetPropertyImpl(Element element, IJavaComment javaComments, ITag tag) {
            super(element, tag.getName(), tag.getValue());
            if ("@associates".equals(this.getName())) {
                this.myPropertyValue = TagPropertyProvider.toDUIN(this.myPropertyValue);
            }
            this.myJavaComments = javaComments;
            this.myTag = tag;
        }

        public boolean canSetValue(String newValue) {
            return TagPropertyProvider.this.getItself().canSetPropertyValue(this.myElement, this.myPropertyName, newValue);
        }

        public void setValue(String newValue) {
            if ("@associates".equals(this.getName())) {
                newValue = TagPropertyProvider.toDUIN(newValue);
            }
            this.myTag.setValue(newValue);
            IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(this.myElement);
            DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(TagPropertyProvider.this.myJavaProject, javaElement, 4);
            this.myJavaComments.synchronize(true);
        }

        public String getValue() {
            String value = super.getValue();
            if ("@associates".equals(this.getName())) {
                return TagPropertyProvider.fromDUIN(value);
            }
            return value;
        }
    }

    private class MyCommentSetPropertyImpl
    extends SetPropertyImpl {
        private IJavaComment myJavaComments;

        public MyCommentSetPropertyImpl(Element element, IJavaComment javaComments) {
            super(element, "$comment", javaComments.getComment());
            this.myJavaComments = javaComments;
        }

        public boolean canSetValue(String newValue) {
            return TagPropertyProvider.this.getItself().canSetPropertyValue(this.myElement, this.myPropertyName, newValue);
        }

        public void setValue(String newValue) {
            this.myJavaComments.setComment(newValue);
            this.myJavaComments.synchronize(true);
        }
    }
}

