/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.MethodBodyUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class ReturnTypePropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$returnType", "$typeReferencedElement"};

    public String getPropertyValue(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, element.getUniqueName());
        try {
            if (javaElement instanceof IMethod) {
                IMethod method = (IMethod)javaElement;
                if ("$returnType".equals(propertyName)) {
                    return Signature.toString((String)method.getReturnType());
                }
                String refType = JDTUtil.getRefType(method);
                return TypeNameResolver.resolveType(this.myModel, method.getDeclaringType(), refType, true);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!this.canChange(element)) {
            return false;
        }
        if (propertyValue == null) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (!(javaElement instanceof IMethod)) {
            return false;
        }
        if ("$returnType".equals(propertyName)) {
            return TypeNameUtil.isPrimitiveType(propertyValue) || TypeNameUtil.isNonPrimitiveType(propertyValue) || TypeNameUtil.isVoid(propertyValue);
        }
        UniqueName uniqueName = ModelAccess.createUniqueName((String)propertyValue);
        return NameUtil.isTypeUniqueName(uniqueName);
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            MySetPropertyOperation propertyOperation = "$returnType".equals(propertyName) ? new MyTypeSetPropertyOperation() : new MyRefTypeSetPropertyOperation();
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, true, propertyName, (Object)propertyValue, null, (PropertyOperation)propertyOperation);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isMethodUniqueName(uniqueName);
    }

    private abstract class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        protected String propertyOperation(IJavaElement javaElement, IDOMMethod domMethod, String typeName) {
            IType type = ((IMethod)javaElement).getDeclaringType();
            typeName = NameUtil.normalizeName(typeName);
            if (ImportStatementSupport.isImportStatamentSupported()) {
                ImportStatementSupport.addImportStatament(ReturnTypePropertyProvider.this.myModel, javaElement, (IDOMNode)domMethod, typeName);
                typeName = NameUtil.getTypeShortName(type, typeName);
            }
            MethodBodyUtil.fixupMethodBody((IMethod)javaElement, domMethod, typeName);
            String contents = domMethod.getContents();
            int nesting = Formatter.getNesting((IMember)javaElement);
            String newContents = Formatter.formatBody(contents, nesting);
            contents = newContents != null ? newContents : contents;
            return contents;
        }

        public abstract String propertyOperation(IJavaElement var1, IDOMNode var2, String var3, Object var4, Object var5);
    }

    private class MyRefTypeSetPropertyOperation
    extends MySetPropertyOperation {
        private MyRefTypeSetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMMethod) {
                UniqueName uniqueName = ModelAccess.createUniqueName((String)((String)newPropertyValue));
                IJavaElement refJavaElement = ElementUtil.getJavaElement(ReturnTypePropertyProvider.this.myModelUniqueName, uniqueName);
                if (refJavaElement instanceof IType) {
                    IType type = (IType)refJavaElement;
                    String typeName = type.getFullyQualifiedName();
                    return this.propertyOperation(javaElement, (IDOMMethod)domNode, typeName);
                }
            }
            return null;
        }
    }

    private class MyTypeSetPropertyOperation
    extends MySetPropertyOperation {
        private MyTypeSetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMMethod) {
                return this.propertyOperation(javaElement, (IDOMMethod)domNode, (String)newPropertyValue);
            }
            return null;
        }
    }
}

