/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.WorkingCopyUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import java.util.Enumeration;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class PropertyOperationUtil {
    private static IDOMFactory ourDOMFactory = new DOMFactory();

    public static boolean doPropertyOperation(Model model, Element element, boolean deltaNeeded, String propertyName, Object newPropertyValue, Object oldPropertyValue, PropertyOperation propertyOperation) throws JavaModelException {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (!(javaElement instanceof IMember)) {
            return false;
        }
        IJavaProject javaProject = ElementUtil.getJavaProject(model.getUniqueName());
        return PropertyOperationUtil.doPropertyOperation(javaProject, javaElement, deltaNeeded, propertyName, newPropertyValue, oldPropertyValue, propertyOperation);
    }

    public static boolean doPropertyOperation(IJavaProject javaProject, IJavaElement javaElement, boolean deltaNeeded, String propertyName, Object newPropertyValue, Object oldPropertyValue, PropertyOperation propertyOperation) throws JavaModelException {
        if (!javaElement.exists()) {
            return false;
        }
        WorkingCopyUtil.initWorkingCopy(javaProject, javaElement);
        javaElement = WorkingCopyUtil.getWorkingCopy(javaElement);
        ICompilationUnit compilationUnit = ((IMember)javaElement).getCompilationUnit();
        IBuffer buffer = compilationUnit.getBuffer();
        if (buffer == null) {
            return false;
        }
        char[] sourceCharsters = buffer.getCharacters();
        IDOMCompilationUnit domCompilationUnit = ourDOMFactory.createCompilationUnit(sourceCharsters, compilationUnit.getElementName());
        IDOMNode necessaryDOMElement = PropertyOperationUtil.findNode((IDOMNode)domCompilationUnit, (IMember)javaElement);
        if (necessaryDOMElement == null) {
            return false;
        }
        String newContent = propertyOperation.propertyOperation(javaElement, necessaryDOMElement, propertyName, newPropertyValue, oldPropertyValue);
        if (newContent == null) {
            return false;
        }
        IDOMMember newMember = PropertyOperationUtil.createNewMember(necessaryDOMElement.getNodeType(), newContent);
        if (newMember == null) {
            return false;
        }
        necessaryDOMElement.insertSibling((IDOMNode)newMember);
        necessaryDOMElement.remove();
        char[] newSourceCharsters = domCompilationUnit.getCharacters();
        buffer.setContents(newSourceCharsters);
        buffer.save(null, true);
        compilationUnit.makeConsistent(null);
        compilationUnit.save(null, true);
        if (deltaNeeded) {
            DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(javaProject, javaElement, 4);
            DeltaPatcherTreeProvider.modelChanged(javaProject);
        }
        return true;
    }

    public static IDOMMember createNewMember(int kind, String content) {
        IDOMField newMember = null;
        if (kind == 5) {
            newMember = ourDOMFactory.createField(content);
        } else if (kind == 6) {
            newMember = ourDOMFactory.createMethod(content);
        } else if (kind == 4) {
            newMember = ourDOMFactory.createType(content);
        }
        return newMember;
    }

    private static IDOMNode findNode(IDOMNode domNode, IMember jdtMember) {
        String jdtContext = null;
        try {
            jdtContext = jdtMember.getSource();
        }
        catch (JavaModelException e) {
            return null;
        }
        IDOMField domMember = null;
        try {
            int elementType = jdtMember.getElementType();
            if (elementType == 8) {
                domMember = ourDOMFactory.createField(jdtContext);
            } else if (elementType == 9) {
                domMember = ourDOMFactory.createMethod(jdtContext);
            } else if (elementType == 7) {
                domMember = ourDOMFactory.createType(jdtContext);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (domMember == null) {
            return null;
        }
        if (domNode.isSignatureEqual(domMember)) {
            return domNode;
        }
        Enumeration domNodeEnum = domNode.getChildren();
        while (domNodeEnum.hasMoreElements()) {
            IDOMNode childDomNode = (IDOMNode)domNodeEnum.nextElement();
            IDOMNode necessaryJavaElement = PropertyOperationUtil.findNode(childDomNode, jdtMember);
            if (necessaryJavaElement == null) continue;
            return necessaryJavaElement;
        }
        return null;
    }
}

