/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.Parameter;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.internal.core.providers.java.property.SetPropertyImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.enum.ArrayEnumeration;
import com.tssap.selena.model.util.enum.SingleEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class ParameterPropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$parameter"};

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    public PropertyEnumeration properties(Element element) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement != null) {
            Object[] properties = this.getProperties(javaElement, element);
            return EnumerationConverter.toPropertyEnumeration((Enumeration)new ArrayEnumeration(properties));
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public String getPropertyValue(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement == null) {
            return null;
        }
        Property[] properties = this.getProperties(javaElement, element);
        StringBuffer parametersBuff = new StringBuffer(1024);
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            PropertyMap subproperties = property.getSubproperties();
            parametersBuff.append(subproperties.getPropertyValue("$type") + " " + subproperties.getPropertyValue("$name"));
            if (i != properties.length - 1) {
                parametersBuff.append(", ");
            }
            ++i;
        }
        return parametersBuff.length() == 0 ? null : parametersBuff.toString();
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return this.canChangePropertyValue(element, propertyName, propertyValue, new MyAddPropertyOperation(true));
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        try {
            if (PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)propertyValue, null, (PropertyOperation)new MyAddPropertyOperation(false))) {
                return new MySetSimplePropertyImpl(this.myModel, element, "$parameter", propertyValue);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return this.canChangePropertyValue(element, propertyName, propertyValue, new MySetPropertyOperation(true));
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)propertyValue, null, (PropertyOperation)new MySetPropertyOperation(false));
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isMethodUniqueName(uniqueName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private Property[] getProperties(IJavaElement javaElement, Element element) {
        if (javaElement instanceof IMethod) {
            ArrayList<ParameterProperty> all = new ArrayList<ParameterProperty>();
            try {
                IMethod method = (IMethod)javaElement;
                IType type = method.getDeclaringType();
                String[] names = method.getParameterNames();
                String[] signatures = method.getParameterTypes();
                if (names != null && signatures != null) {
                    int i = 0;
                    while (i < names.length) {
                        String name = names[i];
                        String sType = Signature.toString((String)signatures[i]);
                        if (TypeNameUtil.isPrimitiveType(sType)) {
                            all.add(new ParameterProperty(this.myModel, javaElement, element, name, sType, sType));
                        } else {
                            String resolvedType = TypeNameResolver.resolveType(this.myModel, type, sType, true);
                            all.add(new ParameterProperty(this.myModel, javaElement, element, name, sType, resolvedType));
                        }
                        ++i;
                    }
                    return all.toArray(new Property[all.size()]);
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return new Property[0];
    }

    private boolean canChangePropertyValue(Element element, String propertyName, String propertyValue, PropertyOperation propertyOperation) {
        if (!this.canChange(element)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (!(javaElement instanceof IMethod)) {
            return false;
        }
        if (propertyValue == null) {
            return true;
        }
        try {
            return PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)propertyValue, null, propertyOperation);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return false;
        }
    }

    class MySetSimplePropertyImpl
    extends SetPropertyImpl {
        public MySetSimplePropertyImpl(Model model, Element element, String propertyName, String propertyValue) {
            super(element, propertyName, propertyValue);
        }

        public boolean canSetValue(String newValue) {
            if ("$name".equals(this.myPropertyName)) {
                if (Parameter.isNameValid(newValue)) {
                    return true;
                }
            } else if ("$type".equals(this.myPropertyName)) {
                if (Parameter.isTypeValid(newValue)) {
                    return true;
                }
            } else if ("$typeReferencedElement".equals(this.myPropertyName)) {
                return false;
            }
            return false;
        }

        public void setValue(String newValue) {
            if (!this.canSetValue(newValue)) {
                return;
            }
            try {
                PropertyOperationUtil.doPropertyOperation(ParameterPropertyProvider.this.myModel, this.myElement, false, this.myPropertyName, (Object)newValue, (Object)this.myPropertyValue, (PropertyOperation)new MySimpleSetPropertyOperation());
                this.myPropertyValue = newValue;
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }

        class MySimpleSetPropertyOperation
        implements PropertyOperation {
            MySimpleSetPropertyOperation() {
            }

            public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
                if (!(domNode instanceof IDOMMethod)) {
                    return null;
                }
                IDOMMethod domMethod = (IDOMMethod)domNode;
                String[] parameterNames = domMethod.getParameterNames();
                String[] parameterTypes = domMethod.getParameterTypes();
                if ("$name".equals(MySetSimplePropertyImpl.this.myPropertyName)) {
                    if ((parameterNames = ArrayUtil.replace(parameterNames, (String)newPropertyValue, (String)oldPropertyValue)) == null) {
                        return null;
                    }
                } else if ("$type".equals(MySetSimplePropertyImpl.this.myPropertyName)) {
                    if ((parameterTypes = ArrayUtil.replace(parameterTypes, (String)newPropertyValue, (String)oldPropertyValue)) == null) {
                        return null;
                    }
                } else if ("$typeReferencedElement".equals(MySetSimplePropertyImpl.this.myPropertyName)) {
                    // empty if block
                }
                domMethod.setParameters(parameterTypes, parameterNames);
                return domMethod.getContents();
            }
        }
    }

    private class ParameterPropertyMap
    implements PropertyMap {
        private HashMap myValues = new HashMap();

        public ParameterPropertyMap(Model model, IJavaElement javaElement, String[] names, String[] values) {
            if (names != null && values != null && names.length == values.length) {
                int i = 0;
                while (i < names.length) {
                    Element element = ElementUtil.getModelElement(ParameterPropertyProvider.this.myModelUniqueName, javaElement);
                    this.myValues.put(names[i], new MySetSimplePropertyImpl(model, element, names[i], values[i]));
                    ++i;
                }
            } else {
                throw new IllegalArgumentException("illegal values");
            }
        }

        public String getPropertyValue(String propertyName) {
            return ((Property)this.myValues.get(propertyName)).getValue();
        }

        public Property getProperty(String propertyName) {
            return (Property)this.myValues.get(propertyName);
        }

        public boolean hasProperty(String propertyName) {
            return this.myValues.containsKey(propertyName);
        }

        public boolean hasPropertyValue(String propertyName, String propertyValue) {
            Property property = this.getProperty(propertyName);
            if (property != null) {
                if (propertyValue != null) {
                    return propertyValue.equals(property.getValue());
                }
                return false;
            }
            return propertyValue == null;
        }

        public PropertyEnumeration properties() {
            return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(this.myValues.values()));
        }

        public PropertyEnumeration properties(String propertyName) {
            if (this.hasProperty(propertyName)) {
                return EnumerationConverter.toPropertyEnumeration((Enumeration)new SingleEnumeration(this.myValues.get(propertyName)));
            }
            return EmptyEnumeration.getPropertyEnumeration();
        }

        public boolean isPropertyWritable(String propertyName) {
            return true;
        }

        public boolean isPropertyReadable(String propertyName) {
            return true;
        }

        public boolean canSetPropertyValue(String propertyName, String propertyValue) {
            return false;
        }

        public boolean canSetPropertyValue(String propertyName, boolean propertyValue) {
            return false;
        }

        public Property setPropertyValue(String propertyName, String propertyValue) {
            return null;
        }

        public void setPropertyValue(String propertyName, boolean propertyValue) {
        }

        public boolean canAddProperty(String propertyName, String propertyValue) {
            return false;
        }

        public Property addProperty(String propertyName, String propertyValue) {
            return null;
        }

        public Model getModel() {
            return null;
        }
    }

    private class ParameterProperty
    extends SetPropertyImpl {
        private PropertyMap mySubproperties;
        private String myName;
        private IJavaElement myJavaElement;

        public ParameterProperty(Model model, IJavaElement javaElement, Element element, String name, String type, String refelement) {
            super(element, "$parameter", type);
            this.myJavaElement = javaElement;
            this.myElement = element;
            this.myName = name;
            ParameterPropertyProvider.this.myModel = model;
            this.mySubproperties = new ParameterPropertyMap(ParameterPropertyProvider.this.myModel, this.myJavaElement, new String[]{"$name", "$type", "$typeReferencedElement"}, new String[]{name, type, refelement});
        }

        public boolean canSetValue(String newValue) {
            if (!ParameterPropertyProvider.this.canChange(this.myElement)) {
                return false;
            }
            if (newValue == null) {
                return true;
            }
            if (newValue.indexOf(",") != -1) {
                return false;
            }
            try {
                return PropertyOperationUtil.doPropertyOperation(ParameterPropertyProvider.this.myModel, this.myElement, false, "$parameter", (Object)newValue, (Object)this.myPropertyValue, (PropertyOperation)new MySetPropertyOperation(true));
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                return false;
            }
        }

        public void setValue(String newValue) {
            try {
                PropertyOperationUtil.doPropertyOperation(ParameterPropertyProvider.this.myModel, this.myElement, false, "$parameter", (Object)newValue, (Object)this.myPropertyValue, (PropertyOperation)new MySetPropertyOperation(false));
                Parameter parameter = new Parameter(newValue);
                this.myPropertyValue = parameter.getType();
                this.myName = parameter.getName();
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }

        public String getValue() {
            return this.myPropertyValue + " " + this.myName;
        }

        public PropertyMap getSubproperties() {
            return this.mySubproperties;
        }
    }

    private abstract class MyPropertyOperation
    implements PropertyOperation {
        protected boolean myOnlyCheck;

        public MyPropertyOperation(boolean onlyCheck) {
            this.myOnlyCheck = onlyCheck;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected String doPropertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, String propertyValue, boolean add, boolean onlyCheck) {
            if (!(domNode instanceof IDOMMethod)) {
                return null;
            }
            IMethod method = (IMethod)javaElement;
            IType type = method.getDeclaringType();
            String name = method.getElementName();
            IDOMMethod domMethod = (IDOMMethod)domNode;
            if (propertyValue == null) {
                if (add) {
                    return null;
                }
                if (onlyCheck) {
                    if (!this.checkExistance(type, method, name, new Parameter[0])) return domMethod.getContents();
                    return null;
                }
                domMethod.setParameters(new String[0], new String[0]);
                return domMethod.getContents();
            }
            String[] parameterNames = domMethod.getParameterNames();
            StringTokenizer stringTokenizer = new StringTokenizer(propertyValue, ",");
            int countTokens = stringTokenizer.countTokens();
            Parameter[] parameters = new Parameter[countTokens];
            int i = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String parameterString = stringTokenizer.nextToken();
                Parameter parameter = new Parameter(parameterString);
                if (!parameter.isValid()) {
                    return null;
                }
                if (add) {
                    if (!parameter.checkName(parameterNames)) return null;
                    parameters[i] = parameter;
                } else {
                    parameters[i] = parameter;
                }
                ++i;
            }
            if (onlyCheck) {
                if (!this.checkExistance(type, method, name, parameters)) return domMethod.getContents();
                return null;
            }
            String[] parameterTypes = domMethod.getParameterTypes();
            String[] newParameterTypes = new String[countTokens];
            String[] newParameterNames = new String[countTokens];
            int i2 = 0;
            while (i2 < countTokens) {
                newParameterTypes[i2] = parameters[i2].getType();
                newParameterNames[i2] = parameters[i2].getName();
                ++i2;
            }
            if (add) {
                newParameterTypes = ArrayUtil.merge(parameterTypes, newParameterTypes);
                newParameterNames = ArrayUtil.merge(parameterNames, newParameterNames);
            }
            if (ImportStatementSupport.isImportStatamentSupported()) {
                int i3 = 0;
                while (i3 < newParameterTypes.length) {
                    ImportStatementSupport.addImportStatament(ParameterPropertyProvider.this.myModel, javaElement, (IDOMNode)domMethod, newParameterTypes[i3]);
                    newParameterTypes[i3] = NameUtil.getTypeShortName(type, newParameterTypes[i3]);
                    ++i3;
                }
            }
            domMethod.setParameters(newParameterTypes, newParameterNames);
            return domMethod.getContents();
        }

        private boolean checkExistance(IType type, IMethod method, String name, Parameter[] params) {
            IMethod existingMethod = type.getMethod(name, this.getParameterTypeSignature(params));
            return existingMethod != null && existingMethod.exists() && !method.equals(existingMethod);
        }

        private String[] getParameterTypeSignature(Parameter[] params) {
            if (params != null) {
                String[] typesSignatures = new String[params.length];
                int i = 0;
                while (i < params.length) {
                    typesSignatures[i] = Signature.createTypeSignature((String)params[i].getType(), (boolean)false);
                    ++i;
                }
                return typesSignatures;
            }
            return new String[0];
        }

        public abstract String propertyOperation(IJavaElement var1, IDOMNode var2, String var3, Object var4, Object var5);
    }

    private class MySetPropertyOperation
    extends MyPropertyOperation {
        public MySetPropertyOperation(boolean onlyCheck) {
            super(onlyCheck);
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            return this.doPropertyOperation(javaElement, domNode, propertyName, (String)newPropertyValue, false, this.myOnlyCheck);
        }
    }

    private class MyAddPropertyOperation
    extends MyPropertyOperation {
        public MyAddPropertyOperation(boolean onlyCheck) {
            super(onlyCheck);
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            return this.doPropertyOperation(javaElement, domNode, propertyName, (String)newPropertyValue, true, this.myOnlyCheck);
        }
    }
}

