/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

class Parameter {
    private String myType = null;
    private String myName = null;
    private boolean myValidParameter = false;
    private static final String SEPARATOR = " ";

    public Parameter(String parameter) {
        if (parameter == null || parameter.length() == 0) {
            return;
        }
        int index = parameter.lastIndexOf(SEPARATOR);
        if (index == -1 || index < 1) {
            return;
        }
        this.myType = parameter.substring(0, index);
        this.myType = this.myType.trim();
        if (!Parameter.isTypeValid(this.myType)) {
            this.myType = null;
            return;
        }
        this.myName = parameter.substring(index);
        this.myName = this.myName.trim();
        if (!Parameter.isNameValid(this.myName)) {
            this.myType = null;
            this.myName = null;
            return;
        }
        this.myValidParameter = true;
    }

    public String getType() {
        return this.myType;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isValid() {
        return this.myValidParameter;
    }

    public static boolean isTypeValid(String type) {
        return TypeNameUtil.isPrimitiveType(type) || TypeNameUtil.isNonPrimitiveType(type);
    }

    public static boolean isNameValid(String name) {
        IStatus status = JavaConventions.validateIdentifier((String)name);
        return status.getSeverity() != 4;
    }

    public boolean checkName(String[] parameterNames) {
        if (!this.isValid()) {
            return false;
        }
        return !ArrayUtil.contains(parameterNames, this.getName());
    }
}

