/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Messages;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.RenameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.GetPropertyImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import org.eclipse.jdt.core.IJavaElement;

public class NamePropertyProvider
extends AbstractGetPropertyProvider
implements PropertyUniqueNameProvider {
    private static final String DEFAULT_PACKAGE_NAME = Messages.getString("default_package_name");
    private static final String BIN_ROOT_DISPLAY_NAME = Messages.getString("libraries_name");
    private static final String REF_ROOT_DISPLAY_NAME = Messages.getString("referenced_name");
    private static final String ASSOCIATION_LINK_VISUAL_NAME = Messages.getString("association_link_name");
    private static final String GENERALIZATION_LINK_VISUAL_NAME = Messages.getString("generalization_link_name");
    private static final String IMPLEMENTATION_LINK_VISUAL_NAME = Messages.getString("implementation_link_name");
    private static final String DEPENDENCY_LINK_VISUAL_NAME = Messages.getString("dependency_link_name");
    private static final String[] PROPERTY_NAMES = new String[]{"$name"};

    public String getPropertyValue(Element element, String propertyName) {
        UniqueName uniqueName = element.getUniqueName();
        if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
            if (NameUtil.isRootUniqueName(uniqueName)) {
                return NamePropertyProvider.getRootVisualName(uniqueName);
            }
            String name = uniqueName.getName();
            return NameUtil.getShortName(name);
        }
        if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            if (NameUtil.isAssociationUniqueName(uniqueName)) {
                return ASSOCIATION_LINK_VISUAL_NAME;
            }
            if (NameUtil.isGeneralizationUniqueName(uniqueName)) {
                return GENERALIZATION_LINK_VISUAL_NAME;
            }
            if (NameUtil.isImplementationUniqueName(uniqueName)) {
                return IMPLEMENTATION_LINK_VISUAL_NAME;
            }
            if (NameUtil.isDependencyUniqueName(uniqueName)) {
                return DEPENDENCY_LINK_VISUAL_NAME;
            }
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        if (!this.hasProperty(element, propertyName)) {
            return null;
        }
        String propertyValue = this.getPropertyValue(element, propertyName);
        return new MySetPropertyImpl(element, propertyName, propertyValue);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        return RenameUtil.canSetName(javaElement, propertyValue, true);
    }

    public UniqueName setPropertyValue(Element element, String propertyName, String propertyValue) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        UniqueName oldUin = element.getUniqueName();
        if (RenameUtil.setName(this.myJavaProject, javaElement, propertyValue)) {
            return NameUtil.getRenamedUniqueName(oldUin, propertyValue);
        }
        return oldUin;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    private static String getRootVisualName(UniqueName uniqueName) {
        if ("bin".equals(uniqueName.getName())) {
            return BIN_ROOT_DISPLAY_NAME;
        }
        if ("ref".equals(uniqueName.getName())) {
            return REF_ROOT_DISPLAY_NAME;
        }
        return "";
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private class MySetPropertyImpl
    extends GetPropertyImpl {
        UniqueName myUniqueName;

        public MySetPropertyImpl(Element element, String propertyName, String propertyValue) {
            super(element, propertyName, propertyValue);
            this.myUniqueName = element.getUniqueName();
        }

        public boolean isWritable() {
            return true;
        }

        public boolean canSetValue(String newValue) {
            if (this.isValid()) {
                IJavaElement javaElement = ElementUtil.getJavaElement(this.getElement());
                return RenameUtil.canSetName(javaElement, newValue, true);
            }
            return false;
        }

        public void setValue(String newValue) {
            if (this.canSetValue(newValue) && this.isValid()) {
                IJavaElement javaElement = ElementUtil.getJavaElement(this.getElement());
                UniqueName oldUin = NameUtil.getJavaElementUniqueName(NamePropertyProvider.this.myJavaProject, javaElement);
                if (RenameUtil.setName(NamePropertyProvider.this.myJavaProject, javaElement, newValue)) {
                    this.myUniqueName = NameUtil.getRenamedUniqueName(oldUin, newValue);
                }
                this.myPropertyValue = newValue;
            }
        }

        public String getValue() {
            return super.getValue();
        }

        public PropertyMap getSubproperties() {
            return null;
        }

        public Element getElement() {
            return NamePropertyProvider.this.myModel.findEntity(this.myUniqueName);
        }
    }
}

