/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.inheritance.InheritanceUtil;
import com.tssap.selena.internal.core.providers.java.property.PropertyMapAdapter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.SingleEnumeration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

class MyRefPropertyMapImpl
extends PropertyMapAdapter {
    private Model myModel;
    private IType myType;
    private Property myProperty;
    private Property mySubProperty;
    private static final String PROPERTY_NAME = "$referencedElement";

    public MyRefPropertyMapImpl(Model model, IType type, Property property, String propertyValue, Element element) {
        this.myType = type;
        this.myProperty = property;
        this.myModel = model;
        this.mySubProperty = new SubPropertyImpl(element);
    }

    public boolean canSetPropertyValue(String propertyName, String propertyValue) {
        String qualifiedName;
        if (propertyValue == null) {
            return this.myProperty.canSetValue(null);
        }
        UniqueName uniqueName = ModelAccess.createUniqueName((String)propertyValue);
        if (NameUtil.isTypeUniqueName(uniqueName) && this.myProperty.canSetValue(qualifiedName = NameUtil.getTypeQualifiedName(uniqueName))) {
            IJavaElement je = ElementUtil.getJavaElement(this.myModel.getUniqueName(), uniqueName);
            if (je != null) {
                return InheritanceUtil.hasNoInheritanceCycle(this.myType, (IType)je);
            }
            return true;
        }
        return false;
    }

    public Property setPropertyValue(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            this.myProperty.setValue(null);
            return this.myProperty;
        }
        if (this.canSetPropertyValue(propertyName, propertyValue)) {
            UniqueName uniqueName = ModelAccess.createUniqueName((String)propertyValue);
            String qualifiedName = NameUtil.getTypeQualifiedName(uniqueName);
            this.myProperty.setValue(qualifiedName);
            return this.myProperty;
        }
        return null;
    }

    public Property getProperty(String propertyName) {
        return this.mySubProperty;
    }

    public String getPropertyValue(String propertyName) {
        String refType = this.myProperty.getValue();
        String stringUniqueName = TypeNameResolver.resolveType(this.myModel, this.myType, refType, true);
        return stringUniqueName;
    }

    public PropertyEnumeration properties() {
        return SingleEnumeration.createPropertyEnumeration((Property)this.mySubProperty);
    }

    private class SubPropertyImpl
    implements Property {
        private Element myElement;

        public SubPropertyImpl(Element element) {
            this.myElement = element;
        }

        public boolean canSetValue(String newValue) {
            return MyRefPropertyMapImpl.this.canSetPropertyValue(this.getName(), newValue);
        }

        public String getName() {
            return MyRefPropertyMapImpl.PROPERTY_NAME;
        }

        public PropertyMap getSubproperties() {
            return null;
        }

        public String getValue() {
            return MyRefPropertyMapImpl.this.getPropertyValue(this.getName());
        }

        public boolean isWritable() {
            return true;
        }

        public void setValue(String newValue) {
            MyRefPropertyMapImpl.this.setPropertyValue(this.getName(), newValue);
        }

        public Element getElement() {
            return this.myElement;
        }
    }
}

