/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.MethodBodyUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

public class ModifiersPropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$public", "$protected", "$private", "$abstract", "$deprecated", "$static", "$final", "$strictfp", "$native", "$transient", "$volatile", "$synchronized", "$compiled", "$synthetic"};
    private static final String JDT_BUG_INTERFACE_STRING1 = "interfacpublic ";
    private static final String JDT_BUG_INTERFACE_STRING2 = "interfacprivate ";
    private static final String JDT_BUG_INTERFACE_STRING3 = "interfacprotected ";
    private static final String JDT_BUG_INTERFACE_STRING4 = "interfacinterface ";

    public boolean hasProperty(Element element, String propertyName) {
        int flags;
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, element.getUniqueName());
        if (!(javaElement instanceof IMember)) {
            return false;
        }
        IMember javaMember = (IMember)javaElement;
        try {
            flags = javaMember.getFlags();
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return false;
        }
        if ("$public".equals(propertyName)) {
            if (Flags.isPublic((int)flags)) {
                return true;
            }
            IType type = javaMember.getDeclaringType();
            try {
                return type != null && type.isInterface();
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        if ("$protected".equals(propertyName)) {
            return Flags.isProtected((int)flags);
        }
        if ("$private".equals(propertyName)) {
            return Flags.isPrivate((int)flags);
        }
        if ("$abstract".equals(propertyName)) {
            boolean result = Flags.isAbstract((int)flags);
            if (javaMember instanceof IMethod && javaMember.getParent() instanceof IType && javaMember.getParent().exists()) {
                try {
                    result |= ((IType)javaMember.getParent()).isInterface();
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
            return result;
        }
        if ("$deprecated".equals(propertyName)) {
            return Flags.isDeprecated((int)flags);
        }
        if ("$static".equals(propertyName)) {
            return Flags.isStatic((int)flags);
        }
        if ("$final".equals(propertyName)) {
            return Flags.isFinal((int)flags);
        }
        if ("$strictfp".equals(propertyName)) {
            return Flags.isStrictfp((int)flags);
        }
        if ("$native".equals(propertyName)) {
            return Flags.isNative((int)flags);
        }
        if ("$transient".equals(propertyName)) {
            return Flags.isTransient((int)flags);
        }
        if ("$volatile".equals(propertyName)) {
            return Flags.isVolatile((int)flags);
        }
        if ("$synchronized".equals(propertyName)) {
            return Flags.isSynchronized((int)flags);
        }
        if ("$compiled".equals(propertyName)) {
            return javaMember.isBinary();
        }
        if ("$synthetic".equals(propertyName)) {
            return Flags.isSynthetic((int)flags);
        }
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (this.hasProperty(element, propertyName)) {
            return AbstractGetPropertyProvider.BOOLEAN_STR;
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getBooleanProperty(element, propertyName);
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Property> properties = new ArrayList<Property>();
        int i = 0;
        while (i < PROPERTY_NAMES.length) {
            Property property;
            if (this.hasProperty(element, PROPERTY_NAMES[i]) && (property = this.getProperty(element, PROPERTY_NAMES[i])) != null) {
                properties.add(property);
            }
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!this.canChange(element)) {
            return false;
        }
        propertyValue = propertyValue == null ? "false" : propertyValue;
        boolean booleanPropertyValue = new Boolean(propertyValue);
        try {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement instanceof IMember) {
                int flags = ((IMember)javaElement).getFlags();
                if (javaElement instanceof IMethod) {
                    if ("$abstract".equals(propertyName)) {
                        boolean result;
                        boolean bl = result = Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || Flags.isNative((int)flags) || Flags.isSynchronized((int)flags);
                        if (result && booleanPropertyValue) {
                            return false;
                        }
                        return !((IType)javaElement.getParent()).isInterface();
                    }
                    if ("$private".equals(propertyName) || "$static".equals(propertyName) || "$native".equals(propertyName) || "$synchronized".equals(propertyName)) {
                        boolean result = Flags.isAbstract((int)flags);
                        return !result || !booleanPropertyValue;
                    }
                }
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)propertyValue, null, (PropertyOperation)new MySetPropertyOperation());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isTypeUniqueName(uniqueName) || NameUtil.isMemberUniqueName(uniqueName);
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            newPropertyValue = newPropertyValue == null ? "false" : newPropertyValue;
            boolean boolPropertyValue = new Boolean((String)newPropertyValue);
            if (domNode instanceof IDOMMember) {
                boolean emptyBody;
                IDOMMethod domMethod;
                boolean needFormating = false;
                IDOMMember domMember = (IDOMMember)domNode;
                int flag = domMember.getFlags();
                if ("$public".equals(propertyName)) {
                    flag = flag & 0xFFFFFFFE & 0xFFFFFFFB & 0xFFFFFFFD;
                    flag = boolPropertyValue ? (flag |= 1) : (flag &= 0xFFFFFFFE);
                } else if ("$protected".equals(propertyName)) {
                    flag = flag & 0xFFFFFFFE & 0xFFFFFFFB & 0xFFFFFFFD;
                    flag = boolPropertyValue ? (flag |= 4) : (flag &= 0xFFFFFFFB);
                } else if ("$private".equals(propertyName)) {
                    flag = flag & 0xFFFFFFFE & 0xFFFFFFFB & 0xFFFFFFFD;
                    flag = boolPropertyValue ? (flag |= 2) : (flag &= 0xFFFFFFFD);
                } else if ("$abstract".equals(propertyName)) {
                    flag = flag & 0xFFFFFFEF & 0xFFFFFBFF & 0xFFFFFFF7;
                    flag = boolPropertyValue ? (flag |= 0x400) : (flag &= 0xFFFFFBFF);
                    if (domNode instanceof IDOMMethod) {
                        needFormating = true;
                        domMethod = (IDOMMethod)domNode;
                        domMethod.setFlags(flag);
                        emptyBody = MethodBodyUtil.isEmptyBody(domMethod, (IMethod)javaElement);
                        MethodBodyUtil.fixupMethodBody((IDOMMethod)domNode, emptyBody);
                    }
                } else if ("$deprecated".equals(propertyName)) {
                    flag = boolPropertyValue ? (flag |= 0x100000) : (flag &= 0xFFEFFFFF);
                } else if ("$static".equals(propertyName)) {
                    flag &= 0xFFFFFFF7;
                    flag = boolPropertyValue ? (flag |= 8) : (flag &= 0xFFFFFFF7);
                    if (domNode instanceof IDOMMethod) {
                        needFormating = true;
                        domMethod = (IDOMMethod)domNode;
                        domMethod.setFlags(flag);
                        emptyBody = MethodBodyUtil.isEmptyBody(domMethod, (IMethod)javaElement);
                        MethodBodyUtil.fixupMethodBody(domMethod, emptyBody);
                    }
                } else if ("$final".equals(propertyName)) {
                    flag = flag & 0xFFFFFFEF & 0xFFFFFBFF;
                    flag = boolPropertyValue ? (flag |= 0x10) : (flag &= 0xFFFFFFEF);
                    if (domNode instanceof IDOMMethod) {
                        needFormating = true;
                        domMethod = (IDOMMethod)domNode;
                        domMethod.setFlags(flag);
                        emptyBody = MethodBodyUtil.isEmptyBody(domMethod, (IMethod)javaElement);
                        MethodBodyUtil.fixupMethodBody((IDOMMethod)domNode, emptyBody);
                    }
                } else if ("$strictfp".equals(propertyName)) {
                    flag = boolPropertyValue ? (flag |= 0x800) : (flag &= 0xFFFFF7FF);
                } else if ("$native".equals(propertyName)) {
                    flag = boolPropertyValue ? (flag |= 0x100) : (flag &= 0xFFFFFEFF);
                    if (domNode instanceof IDOMMethod) {
                        needFormating = true;
                        domMethod = (IDOMMethod)domNode;
                        domMethod.setFlags(flag);
                        emptyBody = MethodBodyUtil.isEmptyBody(domMethod, (IMethod)javaElement);
                        MethodBodyUtil.fixupMethodBody((IDOMMethod)domNode, emptyBody);
                    }
                } else if ("$transient".equals(propertyName)) {
                    flag = boolPropertyValue ? (flag |= 0x80) : (flag &= 0xFFFFFF7F);
                } else if ("$volatile".equals(propertyName)) {
                    flag = boolPropertyValue ? (flag |= 0x40) : (flag &= 0xFFFFFFBF);
                } else if ("$synchronized".equals(propertyName)) {
                    flag = boolPropertyValue ? (flag |= 0x20) : (flag &= 0xFFFFFFDF);
                } else if ("$synthetic".equals(propertyName)) {
                    flag = boolPropertyValue ? (flag |= 0x20000) : (flag &= 0xFFFDFFFF);
                }
                domMember.setFlags(flag);
                if (domMember instanceof IDOMType && !((IDOMType)domMember).isClass()) {
                    IDOMType domIface = (IDOMType)domMember;
                    domIface.setClass(false);
                }
                DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(ModifiersPropertyProvider.this.myJavaProject, javaElement, 4);
                DeltaPatcherTreeProvider.modelChanged(ModifiersPropertyProvider.this.myModel);
                String returnCandidate = domMember.getContents();
                if (boolPropertyValue) {
                    StringBuffer sb = new StringBuffer(returnCandidate);
                    int bugLocation = returnCandidate.indexOf(ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING1);
                    if (bugLocation != -1) {
                        sb.replace(bugLocation, bugLocation + ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING1.length(), "public ");
                        returnCandidate = sb.toString();
                    }
                    if ((bugLocation = returnCandidate.indexOf(ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING2)) != -1) {
                        sb.replace(bugLocation, bugLocation + ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING2.length(), "private ");
                        returnCandidate = sb.toString();
                    }
                    if ((bugLocation = returnCandidate.indexOf(ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING3)) != -1) {
                        sb.replace(bugLocation, bugLocation + ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING3.length(), "protected ");
                        returnCandidate = sb.toString();
                    }
                    if ((bugLocation = returnCandidate.indexOf(ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING4)) != -1) {
                        sb.replace(bugLocation, bugLocation + ModifiersPropertyProvider.JDT_BUG_INTERFACE_STRING4.length(), " ");
                        returnCandidate = sb.toString();
                    }
                }
                if (needFormating) {
                    int nesting = Formatter.getNesting((IMember)javaElement);
                    String newReturnCandidate = Formatter.formatBody(returnCandidate, nesting);
                    returnCandidate = newReturnCandidate != null ? newReturnCandidate : returnCandidate;
                }
                return returnCandidate;
            }
            return null;
        }
    }
}

