/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class ModelPropertiesProvider
extends AbstractSetPropertyProvider {
    private static final String PREFIX = "#";
    private static final String QUALIFIER = "user_properties";
    private static final String[] PROPERTY_NAMES = new String[0];

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!(element instanceof Element) || propertyName == null) {
            return false;
        }
        UniqueName uniqueName = element.getUniqueName();
        return propertyName.startsWith(PREFIX);
    }

    public Property getProperty(Element element, String propertyName) {
        return null;
    }

    public String getPropertyValue(Element element, String propertyName) {
        try {
            if (this.myJavaProject == null) {
                return null;
            }
            IProject project = this.myJavaProject.getProject();
            if (project == null || !project.isOpen()) {
                return null;
            }
            QualifiedName qn = new QualifiedName(QUALIFIER, propertyName);
            return project.getPersistentProperty(qn);
        }
        catch (CoreException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (this.myJavaProject == null) {
            return false;
        }
        IProject project = this.myJavaProject.getProject();
        return project != null && project.isOpen() && !project.isReadOnly();
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            QualifiedName qn = new QualifiedName(QUALIFIER, propertyName);
            IProject project = this.myJavaProject.getProject();
            project.setPersistentProperty(qn, propertyValue);
        }
        catch (CoreException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

