/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class MetachildrenPropertyProvider
extends ModelAwareProvider
implements PropertyGetProvider {
    private static final HashMap PARENT_METACLASSES = new HashMap();

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if ((propertyName == null || "$meta:child:nodes".equals(propertyName) || "$meta:children".equals(propertyName)) && element instanceof Element) {
            String metaclass = element.getPropertyValue("$metaclass");
            return PARENT_METACLASSES.containsKey(metaclass);
        }
        return false;
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        String metaclass = element.getPropertyValue("$metaclass");
        String[] childMetaclasses = (String[])PARENT_METACLASSES.get(metaclass);
        if (childMetaclasses == null || childMetaclasses.length == 0) {
            return null;
        }
        return childMetaclasses[0];
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$meta:child:nodes");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        String metaclass = element.getPropertyValue("$metaclass");
        String[] childMetaclasses = (String[])PARENT_METACLASSES.get(metaclass);
        if (childMetaclasses == null || childMetaclasses.length == 0) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        ArrayList<PropertyAdapter> properties = new ArrayList<PropertyAdapter>(childMetaclasses.length);
        int i = 0;
        while (i < childMetaclasses.length) {
            properties.add(new PropertyAdapter(propertyName, childMetaclasses[i], element));
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(properties));
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        String metaclass = element.getPropertyValue("$metaclass");
        String[] childMetaclasses = (String[])PARENT_METACLASSES.get(metaclass);
        if (childMetaclasses == null || childMetaclasses.length == 0) {
            return false;
        }
        int i = 0;
        while (i < childMetaclasses.length) {
            if (childMetaclasses[i].equals(propertyValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        PARENT_METACLASSES.put("Model", new String[]{"Package", "Class", "Interface"});
        PARENT_METACLASSES.put("Package", new String[]{"Package", "Class", "Interface"});
        PARENT_METACLASSES.put("Interface", new String[]{"Class", "Interface", "Attribute", "Operation"});
        PARENT_METACLASSES.put("Class", new String[]{"Class", "Interface", "Attribute", "Operation", "Property"});
    }
}

