/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.GetPropertyImpl;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.MyRefPropertyMapImpl;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;

abstract class ListPropertyProvider
extends AbstractSetPropertyProvider {
    protected static int K_ANY = 0;
    protected static int K_CLASS = 1;
    protected static int K_INTERFACE = 2;
    protected static int K_EXCEPTION = 3;
    private static final String SUB_PROPERTY_NAME = "$referencedElement";

    ListPropertyProvider() {
    }

    public Property getProperty(Element element, String propertyName) {
        PropertyEnumeration propertyEnumeration = this.properties(element, propertyName);
        if (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            return property;
        }
        return null;
    }

    public String getPropertyValue(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement != null) {
            String[] superNames = this.getPropertyValues(javaElement);
            return this.getWholeValue(superNames);
        }
        return null;
    }

    protected String[] getDifference(String[] newSuperInterfaces, String[] oldSuperInterfaces) {
        ArrayList newList = ArrayUtil.toList(newSuperInterfaces);
        ArrayList oldList = ArrayUtil.toList(oldSuperInterfaces);
        ArrayList diffList = new ArrayList();
        Iterator iter = ((AbstractList)oldList).iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (newList.contains(element)) continue;
            diffList.add(element);
        }
        return diffList.toArray(new String[diffList.size()]);
    }

    protected abstract String[] getPropertyValues(IJavaElement var1);

    protected static boolean validateTypeName(Model model, IType type, String[] typeNames, String newTypeNames, boolean add, int king) {
        String packageName;
        if (type == null || typeNames == null) {
            return false;
        }
        if (newTypeNames == null) {
            return !add;
        }
        if (add && newTypeNames.indexOf(44) != -1) {
            return false;
        }
        if (newTypeNames.indexOf(36) != -1) {
            newTypeNames = NameUtil.normalizeName(newTypeNames);
        }
        packageName = (packageName = type.getPackageFragment().getElementName()).length() == 0 ? "" : packageName + ".";
        StringTokenizer stringTokenizer = new StringTokenizer(newTypeNames, ",");
        while (stringTokenizer.hasMoreElements()) {
            String newTypeName = stringTokenizer.nextToken().trim();
            if (TypeNameUtil.isPrimitiveType(newTypeName)) {
                return false;
            }
            IStatus status = JavaConventions.validateJavaTypeName((String)newTypeName);
            if (status.getSeverity() == 4) {
                return false;
            }
            if (ListPropertyProvider.validateTypeKind(model, type, newTypeName, king)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateTypeKind(Model model, IType type, String fullTypeNames, int king) {
        try {
            if (king == K_CLASS || king == K_INTERFACE || king == K_EXCEPTION) {
                String stUniqueName = TypeNameResolver.resolveType(model, type, fullTypeNames, true);
                UniqueName uniqueName = ModelAccess.createUniqueName((String)stUniqueName);
                IJavaElement javaElement = ElementUtil.getJavaElement(model.getUniqueName(), uniqueName);
                if (javaElement instanceof IType) {
                    IType ttype = (IType)javaElement;
                    if (ttype.isClass() && king == K_CLASS) {
                        return true;
                    }
                    if (ttype.isInterface() && king == K_INTERFACE) {
                        return true;
                    }
                    return king == K_EXCEPTION;
                }
            } else if (king == K_ANY) {
                return true;
            }
            return true;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    protected abstract class PropertyImpl
    extends GetPropertyImpl {
        private IJavaElement myJavaElement;
        private MyRefPropertyMapImpl myPropertyMap;

        public PropertyImpl(IJavaElement javaElement, Element element, String propertyName, String propertyValue) {
            super(element, propertyName, propertyValue);
            this.myJavaElement = javaElement;
        }

        public boolean canSetValue(String newValue) {
            if (ListPropertyProvider.this.canChange(this.myElement) && this.isValid()) {
                if (this.myPropertyValue != null) {
                    IStatus status = JavaConventions.validateJavaTypeName((String)this.myPropertyValue);
                    return status.getSeverity() != 4;
                }
                return true;
            }
            return false;
        }

        public void setValue(String newValue) {
            if (this.canSetValue(newValue)) {
                try {
                    PropertyOperationUtil.doPropertyOperation(ListPropertyProvider.this.myModel, this.myElement, true, this.myPropertyName, (Object)newValue, (Object)this.myPropertyValue, this.getPropertyOperation());
                    if (ImportStatementSupport.isImportStatamentSupported() && newValue != null) {
                        IType type = this.myJavaElement instanceof IType ? (IType)this.myJavaElement : ((IMember)this.myJavaElement).getDeclaringType();
                        this.myPropertyValue = NameUtil.getTypeShortName(type, newValue);
                    } else {
                        this.myPropertyValue = newValue;
                    }
                }
                catch (JavaModelException e) {
                    JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                }
            }
        }

        public PropertyMap getSubproperties() {
            if (this.isValid()) {
                if (this.myPropertyMap == null) {
                    IType type = this.myJavaElement instanceof IType ? (IType)this.myJavaElement : ((IMember)this.myJavaElement).getDeclaringType();
                    this.myPropertyMap = new MyRefPropertyMapImpl(ListPropertyProvider.this.myModel, type, this, this.myPropertyValue, this.getElement());
                }
                return this.myPropertyMap;
            }
            return null;
        }

        public boolean isValid() {
            IJavaElement javaElement = ElementUtil.getJavaElement(this.myElement);
            if (javaElement != null) {
                Object[] values = ListPropertyProvider.this.getPropertyValues(javaElement);
                return ArrayUtil.contains(values, this.myPropertyValue);
            }
            return false;
        }

        protected abstract PropertyOperation getPropertyOperation();
    }
}

