/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;

public class JavaElementPropertyProvider
extends AbstractGetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$java_element", "$java_link"};

    protected boolean isApplicable(UniqueName uniqueName) {
        return super.isApplicable(uniqueName) || NameUtil.isPackageUniqueName(uniqueName);
    }

    public boolean hasProperty(Element element, String propertyName) {
        UniqueName uniqueName = element.getUniqueName();
        if (!"$java_link".equals(propertyName)) {
            if (this.myModelUniqueName.equals(uniqueName) || NameUtil.isJarPackageUniqueName(uniqueName)) {
                IProject project = ModelUinSupport.getProject((UniqueName)this.myModelUniqueName);
                if (project != null) {
                    try {
                        return project.hasNature("org.eclipse.jdt.core.javanature");
                    }
                    catch (CoreException e) {
                        JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                    }
                }
            } else {
                if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
                    return true;
                }
                if (NameUtil.isPackageUniqueName(uniqueName)) {
                    IPackageFragment[] fragments = ElementUtil.getPackageFragmentsByUniqueName(this.myJavaProject, uniqueName);
                    return fragments != null && fragments.length > 0;
                }
            }
        } else {
            return NameUtil.isJavaLinkElementUniqueName(uniqueName, false);
        }
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (this.hasProperty(element, propertyName)) {
            return AbstractGetPropertyProvider.BOOLEAN_STR;
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getBooleanProperty(element, propertyName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

