/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ParsersCache;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ISynchronizer;
import com.tssap.selena.java.javacomment.internal.JavaCommentsPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class JavaCommentsParsersCache {
    static /* synthetic */ Class class$com$tssap$selena$internal$core$providers$java$property$JavaCommentsParsersCache;

    public static IJavaComment get(Element element) {
        IJavaComment javaComment = JavaCommentsParsersCache.getParser(element.getModel(), element.getUniqueName());
        if (javaComment == null) {
            javaComment = JavaCommentsParsersCache.getJavaComments(element);
        }
        return javaComment;
    }

    private static IJavaComment getJavaComments(Element element) {
        if (element == null) {
            return null;
        }
        Element correspondingElement = JavaCommentsParsersCache.getCorrespondingElement(element);
        if (correspondingElement == null) {
            return null;
        }
        UniqueName uniqueName = correspondingElement.getUniqueName();
        IJavaComment javaComments = JavaCommentsPlugin.getDefault().getJavaCommentParser();
        javaComments.setSynchronizer((ISynchronizer)new MySynchronizer(javaComments, element, correspondingElement));
        JavaCommentsParsersCache.putParser(element.getModel(), uniqueName, javaComments);
        return javaComments;
    }

    static Element getCorrespondingElement(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            Model model = element.getModel();
            if (NameUtil.isAssociationUniqueName(uniqueName)) {
                uniqueName = NameUtil.getFUINFromAUIN(uniqueName);
            } else if (NameUtil.isGeneralizationUniqueName(uniqueName)) {
                uniqueName = NameUtil.getTUINFromGUIN(uniqueName);
            } else if (NameUtil.isImplementationUniqueName(uniqueName)) {
                uniqueName = NameUtil.getTUINFromIUIN(uniqueName);
            }
            return model.findEntity(uniqueName);
        }
        return element;
    }

    static IJavaElement getCorrespondingJavaElement(Element element) {
        element = JavaCommentsParsersCache.getCorrespondingElement(element);
        Model model = element.getModel();
        if (element != null) {
            UniqueName uniqueName = element.getUniqueName();
            return ElementUtil.getJavaElement(model.getUniqueName(), uniqueName);
        }
        return null;
    }

    private static void putParser(Model model, UniqueName uniqueName, IJavaComment javaComments) {
        ParsersCache parsersCache = JavaCommentsParsersCache.getCache(model);
        parsersCache.put(uniqueName, javaComments);
    }

    private static IJavaComment getParser(Model model, UniqueName uniqueName) {
        ParsersCache parsersCache = JavaCommentsParsersCache.getCache(model);
        return (IJavaComment)parsersCache.get(uniqueName);
    }

    private static ParsersCache getCache(Model model) {
        ParsersCache ourParsersCache = ParsersCache.getInstance(model, class$com$tssap$selena$internal$core$providers$java$property$JavaCommentsParsersCache == null ? (class$com$tssap$selena$internal$core$providers$java$property$JavaCommentsParsersCache = JavaCommentsParsersCache.class$("com.tssap.selena.internal.core.providers.java.property.JavaCommentsParsersCache")) : class$com$tssap$selena$internal$core$providers$java$property$JavaCommentsParsersCache);
        return ourParsersCache;
    }

    private static int getNameOffsetInSource(IMember member) {
        int result = -1;
        try {
            ISourceRange allRange = member.getSourceRange();
            ISourceRange nameRange = member.getNameRange();
            if (allRange != null && nameRange != null) {
                if (nameRange.getOffset() >= 0 && allRange.getOffset() >= 0 && nameRange.getOffset() > allRange.getOffset() && nameRange.getOffset() < allRange.getOffset() + allRange.getLength()) {
                    result = nameRange.getOffset() - allRange.getOffset();
                }
            } else {
                System.err.println("ATTENTION : source of element is accessible while nameRange is not");
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return -1;
        }
        return result;
    }

    private static String getCommentContent(Element element) {
        try {
            int commentStart;
            IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(element);
            if (!(javaElement instanceof IMember)) {
                return null;
            }
            String source = null;
            try {
                source = ((IMember)javaElement).getSource();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (source == null) {
                return null;
            }
            int nameOffsetInSource = -1;
            ISourceRange allRange = ((IMember)javaElement).getSourceRange();
            ISourceRange nameRange = ((IMember)javaElement).getNameRange();
            if (allRange != null && nameRange != null) {
                if (nameRange.getOffset() >= 0 && allRange.getOffset() >= 0 && nameRange.getOffset() > allRange.getOffset() && nameRange.getOffset() < allRange.getOffset() + allRange.getLength()) {
                    nameOffsetInSource = nameRange.getOffset() - allRange.getOffset();
                }
            } else {
                System.err.println("ATTENTION : source of element is accessible while nameRange is not");
            }
            if (nameOffsetInSource != -1) {
                source = JavaCommentsParsersCache.removeDesignLinksContent(source, nameOffsetInSource);
            }
            if ((commentStart = source.indexOf("/**")) == -1 || nameOffsetInSource != -1 && nameOffsetInSource < commentStart) {
                return null;
            }
            int commentEnd = source.indexOf("*/", commentStart);
            if (commentEnd == -1) {
                return null;
            }
            return source.substring(commentStart, commentEnd + "*/".length());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    private static String removeDesignLinksContent(String source, int lastAllowedLinkPosition) {
        int normalizedStart = JavaCommentsParsersCache.getNormalizedSourceStart(source, lastAllowedLinkPosition);
        return normalizedStart == -1 ? source : source.substring(normalizedStart);
    }

    public static int getNormalizedSourceStart(IMember member) {
        int nameStart = JavaCommentsParsersCache.getNameOffsetInSource(member);
        try {
            return JavaCommentsParsersCache.getNormalizedSourceStart(member.getSource(), nameStart);
        }
        catch (JavaModelException e) {
            return -1;
        }
    }

    private static int getNormalizedSourceStart(String source, int lastAllowedLinkPosition) {
        if (source == null || lastAllowedLinkPosition < 0) {
            return -1;
        }
        int designLinkStart = source.lastIndexOf("/*#", lastAllowedLinkPosition);
        if (designLinkStart == -1) {
            return -1;
        }
        int designLinkEnd = source.indexOf("*/", designLinkStart + "/*#".length());
        return designLinkEnd == -1 ? -1 : designLinkEnd + "*/".length();
    }

    private static String ensureEndsWithCR(String str) {
        if ("".equals(str)) {
            return str;
        }
        if (str.lastIndexOf(JavaProviderPlugin.EOL) != str.length() - 1) {
            return str + JavaProviderPlugin.EOL;
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMMember && javaElement instanceof IMember) {
                IDOMMember domMember;
                IDOMMember normalizedMember = domMember = (IDOMMember)domNode;
                String currentContents = domMember.getContents();
                String possibleDesignLink = "";
                int normalizedStart = JavaCommentsParsersCache.getNormalizedSourceStart(currentContents, JavaCommentsParsersCache.getNameOffsetInSource((IMember)javaElement));
                if (normalizedStart != -1) {
                    possibleDesignLink = JavaCommentsParsersCache.ensureEndsWithCR(currentContents.substring(0, normalizedStart));
                    normalizedMember = PropertyOperationUtil.createNewMember(domMember.getNodeType(), currentContents.substring(normalizedStart));
                    if (normalizedMember == null) {
                        normalizedMember = domMember;
                    }
                }
                String oldComment = normalizedMember.getComment();
                int nesting = Formatter.getNesting((IMember)javaElement);
                String newComment = (String)newPropertyValue;
                if ((newComment = Formatter.formatComment(newComment, nesting)) != null && (oldComment == null || oldComment.length() == 0)) {
                    newComment = newComment + JavaProviderPlugin.EOL;
                }
                normalizedMember.setComment(newComment);
                try {
                    String result = possibleDesignLink + normalizedMember.getContents();
                    return result;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    JavaProviderPlugin.getDefault().logException(e);
                    return null;
                }
            }
            return null;
        }
    }

    private static class MySynchronizer
    implements ISynchronizer {
        private IJavaComment myJavaComments;
        private Model myModel;
        private Element myElement;
        private Element myCorrespondingElement;

        MySynchronizer(IJavaComment javaComments, Element element, Element correspondingElement) {
            this.myModel = element.getModel();
            this.myElement = element;
            this.myCorrespondingElement = correspondingElement;
            this.myJavaComments = javaComments;
        }

        public String doSynchronizeFrom() {
            return JavaCommentsParsersCache.getCommentContent(this.myCorrespondingElement);
        }

        public void doSynchronizeTo(String content) {
            try {
                PropertyOperationUtil.doPropertyOperation(this.myModel, this.myCorrespondingElement, true, null, (Object)this.myJavaComments.getContent(), null, (PropertyOperation)new MySetPropertyOperation());
                IJavaElement javaElement = JavaCommentsParsersCache.getCorrespondingJavaElement(this.myElement);
                DeltaPatcherTreeProvider.putAdditionalModelElementDelta(this.myModel, this.myElement.getUniqueName(), ModelDeltaNodeKind.CHANGED, false);
                IJavaProject javaProject = ElementUtil.getJavaProject(this.myModel.getUniqueName());
                DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(javaProject, javaElement, 4);
                DeltaPatcherTreeProvider.modelChanged(this.myModel);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }
}

