/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

public class InterfacePropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$interface"};

    public boolean hasProperty(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, element.getUniqueName());
        if (javaElement instanceof IType) {
            try {
                return ((IType)javaElement).isInterface();
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (this.hasProperty(element, propertyName)) {
            return AbstractGetPropertyProvider.BOOLEAN_STR;
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getBooleanProperty(element, propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (this.isBooleanPropertyValue(propertyValue)) {
            return this.canSetPropertyValue(element, propertyName);
        }
        return false;
    }

    private boolean canSetPropertyValue(Element element, String propertyName) {
        if (!this.canChange(element)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        return javaElement instanceof IType;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        Boolean value = this.getBooleanValue(propertyValue);
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)value, null, (PropertyOperation)new MySetPropertyOperation());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isTypeUniqueName(uniqueName);
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            IDOMType domType;
            if (domNode instanceof IDOMType && (domType = (IDOMType)domNode).isClass()) {
                domType.setClass(false);
                return domType.getContents();
            }
            return null;
        }
    }
}

