/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class InitialValuePropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$initialValue"};

    public String getPropertyValue(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement instanceof IField) {
            return InitialValuePropertyProvider.getInitializer((IField)javaElement);
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!this.canChange(element)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        return javaElement instanceof IField;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, false, propertyName, (Object)propertyValue, null, (PropertyOperation)new MySetPropertyOperation());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    public static String getInitializer(IField field) {
        block5: {
            try {
                IDOMField domField;
                String source = field.getSource();
                if (source == null) break block5;
                try {
                    domField = new DOMFactory().createField(source);
                }
                catch (NullPointerException e) {
                    return null;
                }
                if (domField != null) {
                    String initializer = domField.getInitializer();
                    return initializer != null ? initializer.trim() : null;
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return null;
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        return NameUtil.isFieldUniqueName(uniqueName);
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (domNode instanceof IDOMField) {
                String newValue = (String)newPropertyValue;
                ((IDOMField)domNode).setInitializer(newValue);
                return domNode.getContents();
            }
            return null;
        }
    }
}

