/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.NullMonitor;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Enumeration;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMNode;

public class ImportStatementSupport {
    private static final String LANG_PACK = "java.lang.";

    public static boolean isImportStatamentSupported() {
        return JavaProviderPlugin.isImportOptimizationEnabled();
    }

    public static boolean addImportStatament(Model model, IJavaElement javaElement, String typeName) {
        String fullClassName;
        if (!ImportStatementSupport.isImportStatamentSupported()) {
            return false;
        }
        if (javaElement == null || typeName == null) {
            return false;
        }
        if (TypeNameUtil.isPrimitiveType(typeName) || TypeNameUtil.isVoid(typeName)) {
            return false;
        }
        IType type = null;
        if (javaElement instanceof IType) {
            type = (IType)javaElement;
        } else if (javaElement instanceof IMember) {
            type = ((IMember)javaElement).getDeclaringType();
        }
        if (type == null) {
            return false;
        }
        if (typeName.endsWith(type.getElementName())) {
            return false;
        }
        UniqueName typeUniqueName = NameUtil.getTypeUniqueName("src", typeName);
        Entity element = model.findEntity(typeUniqueName);
        if (element == null && (element = model.findEntity(typeUniqueName = NameUtil.getTypeUniqueName("bin", typeName))) == null) {
            typeUniqueName = NameUtil.getTypeUniqueName("ref", typeName);
            element = model.findEntity(typeUniqueName);
        }
        if (element == null) {
            return false;
        }
        IJavaElement refJavaElement = ElementUtil.getJavaElement((Element)element);
        if (!(refJavaElement instanceof IType)) {
            return false;
        }
        IPackageFragment refPackageFragment = JDTUtil.getPackageFragment(refJavaElement);
        if (refPackageFragment == null) {
            return true;
        }
        IPackageFragment packageFragment = JDTUtil.getPackageFragment(javaElement);
        if (packageFragment == null) {
            return true;
        }
        String packageFragmentName = refPackageFragment.getElementName();
        String refPackageFragmentName = packageFragment.getElementName();
        if (refPackageFragmentName.equals(packageFragmentName)) {
            return true;
        }
        if (refPackageFragmentName.startsWith(LANG_PACK)) {
            return true;
        }
        String importStatement = fullClassName = ((IType)refJavaElement).getFullyQualifiedName();
        ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
        if (compilationUnit == null) {
            return false;
        }
        try {
            IImportDeclaration[] importDeclaration = compilationUnit.getImports();
            int i = 0;
            while (i < importDeclaration.length) {
                if (fullClassName.equals(importDeclaration[i])) {
                    return true;
                }
                ++i;
            }
            compilationUnit.createImport(importStatement, null, null);
            return true;
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return false;
        }
    }

    public static boolean addImportStatament(Model model, IJavaElement javaElement, IDOMNode domNode, String typeName) {
        Entity element;
        if (!ImportStatementSupport.isImportStatamentSupported()) {
            return false;
        }
        if (javaElement == null || typeName == null) {
            return false;
        }
        if (TypeNameUtil.isPrimitiveType(typeName) || TypeNameUtil.isVoid(typeName)) {
            return false;
        }
        IPackageFragment packageFragment = JDTUtil.getPackageFragment(javaElement);
        if (packageFragment == null) {
            return false;
        }
        UniqueName typeUniqueName = ModelAccess.createUniqueName((String)typeName);
        if (NameUtil.isJavaElementUniqueName(typeUniqueName, false)) {
            element = model.findEntity(typeUniqueName);
        } else {
            IType type = null;
            if (javaElement instanceof IType) {
                type = (IType)javaElement;
            } else if (javaElement instanceof IMember) {
                type = ((IMember)javaElement).getDeclaringType();
            }
            if (type == null) {
                return false;
            }
            if (typeName.endsWith(type.getElementName())) {
                return false;
            }
            if ((typeName = TypeNameResolver.resolveType(model, type, typeName, false)) == null) {
                return false;
            }
            typeUniqueName = NameUtil.getTypeUniqueName("src", typeName);
            element = model.findEntity(typeUniqueName);
            if (element == null && (element = model.findEntity(typeUniqueName = NameUtil.getTypeUniqueName("bin", typeName))) == null) {
                typeUniqueName = NameUtil.getTypeUniqueName("ref", typeName);
                element = model.findEntity(typeUniqueName);
            }
        }
        if (element == null) {
            return false;
        }
        IJavaElement refJavaElement = ElementUtil.getJavaElement((Element)element);
        if (!(refJavaElement instanceof IType)) {
            return false;
        }
        IPackageFragment refPackageFragment = JDTUtil.getPackageFragment(refJavaElement);
        if (refPackageFragment == null) {
            return false;
        }
        String packageFragmentName = refPackageFragment.getElementName();
        String refPackageFragmentName = packageFragment.getElementName();
        if (refPackageFragmentName.equals(packageFragmentName)) {
            return true;
        }
        if (refPackageFragmentName.startsWith(LANG_PACK)) {
            return true;
        }
        String fullClassName = ((IType)refJavaElement).getFullyQualifiedName();
        String importStatement = "import " + fullClassName + ";" + JavaProviderPlugin.EOL;
        IDOMImport domImport = new DOMFactory().createImport(importStatement);
        if (domImport != null) {
            IDOMNode domParentNode = domNode;
            while (domParentNode != null) {
                if (!((domParentNode = domParentNode.getParent()) instanceof IDOMCompilationUnit)) continue;
                if (domParentNode.canHaveChildren()) {
                    Enumeration children = domParentNode.getChildren();
                    IDOMNode lastDomImport = null;
                    while (children.hasMoreElements()) {
                        IDOMNode child = (IDOMNode)children.nextElement();
                        if (child.getNodeType() == 3) {
                            String importString = child.getName();
                            if (!(importString = importString.trim()).equals(fullClassName)) continue;
                            return true;
                        }
                        if (child.getNodeType() != 4) continue;
                        lastDomImport = child;
                    }
                    if (lastDomImport != null) {
                        lastDomImport.insertSibling((IDOMNode)domImport);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static void deleteImportStatament(IJavaElement javaElement, String typeName) {
        ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
        if (compilationUnit == null) {
            return;
        }
        try {
            String source = compilationUnit.getBuffer().getContents();
            String fullName = ImportStatementSupport.getDeletableImportStatament(javaElement, source, typeName);
            if (fullName != null) {
                IType type = (IType)javaElement;
                IImportDeclaration importDeclaration = compilationUnit.getImport(fullName);
                if (importDeclaration != null && importDeclaration.exists()) {
                    importDeclaration.delete(true, NullMonitor.getSharedInstance());
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    public static void deleteImportStatament(IJavaElement javaElement, IDOMNode domNode, String typeName) {
        IDOMCompilationUnit domCompilationUnit = JDTUtil.getCompilationUnit(domNode);
        if (domCompilationUnit == null) {
            return;
        }
        String fullName = ImportStatementSupport.getDeletableImportStatament(javaElement, domCompilationUnit.getContents(), typeName);
        if (fullName != null) {
            Enumeration children = domCompilationUnit.getChildren();
            while (children.hasMoreElements()) {
                IDOMNode child = (IDOMNode)children.nextElement();
                if (child.getNodeType() != 3) continue;
                String importString = child.getName();
                if (!(importString = importString.trim()).equals(fullName)) continue;
                child.remove();
            }
        }
    }

    private static String getDeletableImportStatament(IJavaElement javaElement, String source, String typeName) {
        if (!ImportStatementSupport.isImportStatamentSupported()) {
            return null;
        }
        if (javaElement == null || typeName == null) {
            return null;
        }
        if (TypeNameUtil.isPrimitiveType(typeName = typeName.trim()) || TypeNameUtil.isVoid(typeName)) {
            return null;
        }
        if (javaElement instanceof IType && javaElement.exists()) {
            IType type = (IType)javaElement;
            String shortName = NameUtil.getShortName(typeName);
            int c1 = ImportStatementSupport.check(source, "." + shortName);
            int c2 = ImportStatementSupport.check(source, " " + shortName);
            if (c1 == 1 && c2 == 0) {
                return ImportStatementSupport.getResolvedFullName(type, typeName);
            }
        }
        return null;
    }

    private static String getResolvedFullName(IType type, String typeName) {
        try {
            String[][] resolvedType = type.resolveType(typeName);
            if (resolvedType != null && resolvedType.length > 0) {
                String packageName = resolvedType[0][0] == null || resolvedType[0][0].length() == 0 ? "" : resolvedType[0][0] + ".";
                String fullName = packageName + resolvedType[0][1];
                return fullName;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private static int check(String source, String shortName) {
        int index = 0;
        int length = shortName.length();
        int count = 0;
        while ((index = source.indexOf(shortName, index)) != -1) {
            char ch = source.charAt(index += length);
            if (Character.isLetterOrDigit(ch)) continue;
            ++count;
        }
        return count;
    }
}

