/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.TypeHelper;
import com.tssap.selena.internal.core.providers.java.delta.DeltaPatcherTreeProvider;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.ListPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

public class ImplementsListPropertyProvider
extends ListPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$implements"};

    public PropertyEnumeration properties(Element element) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        String[] propertyValues = this.getPropertyValues(javaElement);
        ArrayList<MyPropertyImpl> properties = new ArrayList<MyPropertyImpl>();
        int i = 0;
        while (i < propertyValues.length) {
            properties.add(new MyPropertyImpl(javaElement, element, propertyValues[i]));
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(((AbstractList)properties).iterator());
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return this.canModifyPropertyValue(element, propertyValue, true);
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        try {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            if (javaElement != null && PropertyOperationUtil.doPropertyOperation(this.myJavaProject, javaElement, true, propertyName, (Object)propertyValue, null, (PropertyOperation)new MyAddPropertyOperation())) {
                return new MyPropertyImpl(javaElement, element, propertyValue);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return this.canModifyPropertyValue(element, propertyValue, false);
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            PropertyOperationUtil.doPropertyOperation(this.myModel, element, true, propertyName, (Object)propertyValue, null, (PropertyOperation)new MySetPropertyOperation());
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    private boolean canModifyPropertyValue(Element element, String propertyValue, boolean add) {
        if (!this.canChange(element)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (!(javaElement instanceof IType)) {
            return false;
        }
        if (propertyValue == null) {
            return true;
        }
        IType type = (IType)javaElement;
        String[] typeNames = this.getPropertyValues((IJavaElement)type);
        String newTypeName = propertyValue;
        return ListPropertyProvider.validateTypeName(this.myModel, type, typeNames, newTypeName, add, ListPropertyProvider.K_INTERFACE);
    }

    protected boolean isApplicable(UniqueName uniqueName) {
        if (NameUtil.isTypeUniqueName(uniqueName)) {
            try {
                IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName);
                if (javaElement instanceof IType) {
                    return ((IType)javaElement).isClass();
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return false;
    }

    protected String[] getPropertyValues(IJavaElement javaElement) {
        try {
            IType type = (IType)javaElement;
            if (type.isClass()) {
                String[] superInterfaceNames = type.getSuperInterfaceNames();
                if (superInterfaceNames == null) {
                    return new String[0];
                }
                return superInterfaceNames;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return new String[0];
    }

    private String doPropertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object propertyValue, boolean add) {
        if (!(domNode instanceof IDOMType)) {
            return null;
        }
        DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(this.myJavaProject, javaElement, 3);
        IType type = (IType)javaElement;
        IDOMType domType = (IDOMType)domNode;
        if (propertyValue == null) {
            if (add) {
                return null;
            }
            String[] existing = domType.getSuperInterfaces();
            if (existing != null && existing.length > 1) {
                domType.setSuperInterfaces(new String[]{existing[0]});
            }
            return TypeHelper.removeLastSuperinterface(domType);
        }
        StringTokenizer st = new StringTokenizer((String)propertyValue, ",");
        String[] newSuperInterfaces = new String[st.countTokens()];
        int i = 0;
        while (i < newSuperInterfaces.length) {
            String typeName = st.nextToken().trim();
            typeName = NameUtil.normalizeName(typeName);
            if (ImportStatementSupport.isImportStatamentSupported() && ImportStatementSupport.addImportStatament(this.myModel, javaElement, domNode, typeName)) {
                typeName = NameUtil.getTypeShortName(type, typeName);
            }
            newSuperInterfaces[i] = typeName;
            ++i;
        }
        if (add) {
            int i2 = 0;
            while (i2 < newSuperInterfaces.length) {
                domType.addSuperInterface(newSuperInterfaces[i2]);
                ++i2;
            }
            String content = TypeHelper.removeUnnecessarySpaces(domType.getContents());
            return content;
        }
        if (newSuperInterfaces.length == 0) {
            return TypeHelper.removeLastSuperinterface(domType);
        }
        domType.setSuperInterfaces(newSuperInterfaces);
        return domType.getContents();
    }

    private class MyPropertyImpl
    extends ListPropertyProvider.PropertyImpl {
        public MyPropertyImpl(IJavaElement javaElement, Element element, String propertyValue) {
            super(ImplementsListPropertyProvider.this, javaElement, element, "$implements", propertyValue);
        }

        protected PropertyOperation getPropertyOperation() {
            return new PropertyOperation(){

                public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
                    if (!(domNode instanceof IDOMType)) {
                        return null;
                    }
                    DeltaPatcherTreeProvider.putAdditionalJavaElementDelta(ImplementsListPropertyProvider.this.myJavaProject, javaElement, 3);
                    IType type = (IType)javaElement;
                    IDOMType domType = (IDOMType)domNode;
                    String typeName = (String)newPropertyValue;
                    typeName = NameUtil.normalizeName(typeName);
                    String[] superInterfaces = domType.getSuperInterfaces();
                    String[] oldSuperInterfaces = new String[superInterfaces.length];
                    System.arraycopy(superInterfaces, 0, oldSuperInterfaces, 0, superInterfaces.length);
                    int i = 0;
                    while (i < superInterfaces.length) {
                        if (((String)oldPropertyValue).endsWith(superInterfaces[i])) {
                            if (newPropertyValue != null) {
                                if (ImportStatementSupport.isImportStatamentSupported() && ImportStatementSupport.addImportStatament(ImplementsListPropertyProvider.this.myModel, javaElement, domNode, typeName)) {
                                    typeName = NameUtil.getTypeShortName(type, typeName);
                                }
                                superInterfaces[i] = typeName;
                            } else {
                                superInterfaces = ArrayUtil.remove(superInterfaces, i);
                            }
                            if (superInterfaces.length == 0) {
                                return TypeHelper.removeLastSuperinterface(domType);
                            }
                            domType.setSuperInterfaces(superInterfaces);
                            String[] importsToDelete = ImplementsListPropertyProvider.this.getDifference(superInterfaces, oldSuperInterfaces);
                            int l = 0;
                            while (l < importsToDelete.length) {
                                ImportStatementSupport.deleteImportStatament(javaElement, domNode, importsToDelete[l]);
                                ++l;
                            }
                            return domType.getContents();
                        }
                        ++i;
                    }
                    return null;
                }
            };
        }
    }

    private class MySetPropertyOperation
    implements PropertyOperation {
        private MySetPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            return ImplementsListPropertyProvider.this.doPropertyOperation(javaElement, domNode, propertyName, newPropertyValue, false);
        }
    }

    private class MyAddPropertyOperation
    implements PropertyOperation {
        private MyAddPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            return ImplementsListPropertyProvider.this.doPropertyOperation(javaElement, domNode, propertyName, newPropertyValue, true);
        }
    }
}

