/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.internal.core.providers.java.property.AbstractSetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;

public class HiddenFieldPropertyProvider
extends AbstractSetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$hidden_field"};

    public boolean hasProperty(Element element, String propertyName) {
        IJavaElement javaElement;
        if (JavaProviderPlugin.isShowNoneAttributes()) {
            IJavaElement javaElement2 = ElementUtil.getJavaElement(element);
            if (javaElement2 instanceof IField) {
                String refType = JDTUtil.getRefType((IField)javaElement2);
                return refType != null && TypeNameUtil.isNonPrimitiveType(refType);
            }
        } else if (JavaProviderPlugin.isShowPrefixedAttributes() && (javaElement = ElementUtil.getJavaElement(element)) instanceof IField) {
            String refType;
            IField field = (IField)javaElement;
            String linkPrefix = JavaProviderPlugin.getLinkFieldPrefix();
            if (field.getElementName().startsWith(linkPrefix) && (refType = JDTUtil.getRefType(field)) != null && TypeNameUtil.isNonPrimitiveType(refType)) {
                return true;
            }
        }
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (this.hasProperty(element, propertyName)) {
            return AbstractGetPropertyProvider.BOOLEAN_STR;
        }
        return null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String value) {
        if (this.getPropertyValue(element, propertyName) != null) {
            return this.getPropertyValue(element, propertyName).equals(value);
        }
        return super.hasPropertyValue(element, propertyName, value);
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getBooleanProperty(element, propertyName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

