/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class FullNamePropertyProvider
extends AbstractGetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$fullName"};

    protected boolean isApplicable(UniqueName uniqueName) {
        return super.isApplicable(uniqueName) || NameUtil.isPackageUniqueName(uniqueName) || this.myModel.equals(uniqueName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (element instanceof Model) {
            return "";
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement instanceof IPackageFragment) {
            return NameUtil.getPackageQualifiedName((IPackageFragment)javaElement);
        }
        if (javaElement instanceof IType) {
            String fullName = NameUtil.getTypeQualifiedName((IType)javaElement);
            fullName = NameUtil.normalizeName(fullName);
            fullName = NameUtil.fixupTypeNameForJDT(fullName);
            return fullName;
        }
        if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            String fullName = NameUtil.getTypeQualifiedName(method.getDeclaringType());
            fullName = NameUtil.normalizeName(fullName);
            fullName = NameUtil.fixupTypeNameForJDT(fullName);
            fullName = fullName + "." + method.getElementName();
            return fullName;
        }
        if (javaElement instanceof IField) {
            String fullName = NameUtil.getFieldQualifiedName((IField)javaElement);
            return NameUtil.normalizeName(fullName);
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

