/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.AbstractGetPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class FilePropertyProvider
extends AbstractGetPropertyProvider {
    private static final String[] PROPERTY_NAMES = new String[]{"$file"};

    public String getPropertyValue(Element element, String propertyName) {
        UniqueName uniqueName = element.getUniqueName();
        if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            uniqueName = NameUtil.getParentUniqueName(this.myModelUniqueName, uniqueName);
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName);
        try {
            if (javaElement != null) {
                IResource resource = null;
                if (javaElement instanceof IMember) {
                    ICompilationUnit compilationUnit = ((IMember)javaElement).getCompilationUnit();
                    if (compilationUnit != null && compilationUnit.exists()) {
                        ICompilationUnit originalCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement();
                        resource = originalCompilationUnit != null ? originalCompilationUnit.getUnderlyingResource() : compilationUnit.getUnderlyingResource();
                    }
                } else if (javaElement instanceof IPackageFragment) {
                    resource = javaElement.getUnderlyingResource();
                }
                if (resource != null) {
                    IPath path = resource.getProjectRelativePath();
                    return path.toString();
                }
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        return this.getStringProperty(element, propertyName);
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }
}

