/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java.property;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorInputObjectPropertyProvider
implements ObjectPropertyProvider,
PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (NameUtil.isJavaUniqueName(element.getUniqueName())) {
            IJavaElement javaElement = ElementUtil.getJavaElement(element);
            return javaElement != null && javaElement.exists() && javaElement.getElementType() > 4;
        }
        return false;
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        return EditorInputObjectPropertyProvider.getEditorInput(javaElement);
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        Object result = this.getObjectPropertyValue(element, propertyName);
        return result == null ? EmptyEnumeration.getEnumeration() : Collections.enumeration(Collections.singletonList(result));
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public String getPropertyValue(Element element, String propertyName) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        IEditorInput editorInput = EditorInputObjectPropertyProvider.getEditorInput(javaElement);
        return editorInput == null ? null : EditorInputObjectPropertyProvider.getEditorId(editorInput);
    }

    public Property getProperty(Element element, String propertyName) {
        String result = this.getPropertyValue(element, propertyName);
        return result == null ? null : new PropertyAdapter(propertyName, result, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property result = this.getProperty(element, propertyName);
        return result == null ? EmptyEnumeration.getPropertyEnumeration() : SingleEnumeration.createPropertyEnumeration((Property)result);
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$com.tssap.selena.model.ui.EditorID");
    }

    private static IEditorInput getEditorInput(IJavaElement element) {
        while (element != null && element.getElementType() > 4) {
            if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                element = ((IWorkingCopy)element).getOriginalElement();
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)element;
                try {
                    IResource resource = unit.getUnderlyingResource();
                    return resource instanceof IFile ? new FileEditorInput((IFile)resource) : null;
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (element instanceof IClassFile) {
                return new InternalClassFileEditorInput((IClassFile)element);
            }
            element = element.getParent();
        }
        return null;
    }

    private static String getEditorId(IEditorInput input) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        return descriptor != null ? descriptor.getId() : null;
    }
}

